/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mergejoin;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.mergejoin.MergeJoin;
import org.pentaho.di.trans.steps.mergejoin.MergeJoinData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class MergeJoinMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = MergeJoinMeta.class;
    public static final String[] join_types = new String[]{"INNER", "LEFT OUTER", "RIGHT OUTER", "FULL OUTER"};
    public static final boolean[] one_optionals = new boolean[]{false, false, true, true};
    public static final boolean[] two_optionals = new boolean[]{false, true, false, true};
    private String joinType;
    private String[] keyFields1;
    private String[] keyFields2;

    public String getJoinType() {
        return this.joinType;
    }

    public void setJoinType(String joinType) {
        this.joinType = joinType;
    }

    public String[] getKeyFields1() {
        return this.keyFields1;
    }

    public void setKeyFields1(String[] keyFields1) {
        this.keyFields1 = keyFields1;
    }

    public String[] getKeyFields2() {
        return this.keyFields2;
    }

    public void setKeyFields2(String[] keyFields2) {
        this.keyFields2 = keyFields2;
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrKeys1, int nrKeys2) {
        this.keyFields1 = new String[nrKeys1];
        this.keyFields2 = new String[nrKeys2];
    }

    @Override
    public Object clone() {
        MergeJoinMeta retval = (MergeJoinMeta)super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
        retval.append(XMLHandler.addTagValue((String)"join_type", (String)this.getJoinType()));
        retval.append(XMLHandler.addTagValue((String)"step1", (String)infoStreams.get(0).getStepname()));
        retval.append(XMLHandler.addTagValue((String)"step2", (String)infoStreams.get(1).getStepname()));
        retval.append("    <keys_1>" + Const.CR);
        for (i = 0; i < this.keyFields1.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"key", (String)this.keyFields1[i]));
        }
        retval.append("    </keys_1>" + Const.CR);
        retval.append("    <keys_2>" + Const.CR);
        for (i = 0; i < this.keyFields2.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"key", (String)this.keyFields2[i]));
        }
        retval.append("    </keys_2>" + Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node keynode;
            int i;
            Node keysNode1 = XMLHandler.getSubNode((Node)stepnode, (String)"keys_1");
            Node keysNode2 = XMLHandler.getSubNode((Node)stepnode, (String)"keys_2");
            int nrKeys1 = XMLHandler.countNodes((Node)keysNode1, (String)"key");
            int nrKeys2 = XMLHandler.countNodes((Node)keysNode2, (String)"key");
            this.allocate(nrKeys1, nrKeys2);
            for (i = 0; i < nrKeys1; ++i) {
                keynode = XMLHandler.getSubNodeByNr((Node)keysNode1, (String)"key", (int)i);
                this.keyFields1[i] = XMLHandler.getNodeValue((Node)keynode);
            }
            for (i = 0; i < nrKeys2; ++i) {
                keynode = XMLHandler.getSubNodeByNr((Node)keysNode2, (String)"key", (int)i);
                this.keyFields2[i] = XMLHandler.getNodeValue((Node)keynode);
            }
            List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
            infoStreams.get(0).setSubject(XMLHandler.getTagValue((Node)stepnode, (String)"step1"));
            infoStreams.get(1).setSubject(XMLHandler.getTagValue((Node)stepnode, (String)"step2"));
            this.joinType = XMLHandler.getTagValue((Node)stepnode, (String)"join_type");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"MergeJoinMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.joinType = join_types[0];
        this.allocate(0, 0);
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            int nrKeys1 = rep.countNrStepAttributes(id_step, "keys_1");
            int nrKeys2 = rep.countNrStepAttributes(id_step, "keys_2");
            this.allocate(nrKeys1, nrKeys2);
            for (i = 0; i < nrKeys1; ++i) {
                this.keyFields1[i] = rep.getStepAttributeString(id_step, i, "keys_1");
            }
            for (i = 0; i < nrKeys2; ++i) {
                this.keyFields2[i] = rep.getStepAttributeString(id_step, i, "keys_2");
            }
            List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
            infoStreams.get(0).setSubject(rep.getStepAttributeString(id_step, "step1"));
            infoStreams.get(1).setSubject(rep.getStepAttributeString(id_step, "step2"));
            this.joinType = rep.getStepAttributeString(id_step, "join_type");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MergeJoinMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StreamInterface stream : this.getStepIOMeta().getInfoStreams()) {
            stream.setStepMeta(StepMeta.findStep(steps, (String)stream.getSubject()));
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            for (i = 0; i < this.keyFields1.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "keys_1", this.keyFields1[i]);
            }
            for (i = 0; i < this.keyFields2.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "keys_2", this.keyFields2[i]);
            }
            List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
            rep.saveStepAttribute(id_transformation, id_step, "step1", infoStreams.get(0).getStepname());
            rep.saveStepAttribute(id_transformation, id_step, "step2", infoStreams.get(1).getStepname());
            rep.saveStepAttribute(id_transformation, id_step, "join_type", this.getJoinType());
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MergeJoinMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MergeJoinMeta.CheckResult.StepNotVerified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        int i;
        if (info != null) {
            for (i = 0; i < info.length; ++i) {
                if (info[i] == null) continue;
                r.mergeRowMeta(info[i]);
            }
        }
        for (i = 0; i < r.size(); ++i) {
            r.getValueMeta(i).setOrigin(name);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MergeJoin(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MergeJoinData();
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (this.ioMeta == null) {
            this.ioMeta = new StepIOMeta(true, true, false, false, false, false);
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"MergeJoinMeta.InfoStream.FirstStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"MergeJoinMeta.InfoStream.SecondStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
        }
        return this.ioMeta;
    }

    @Override
    public void resetStepIoMeta() {
    }

    @Override
    public TransMeta.TransformationType[] getSupportedTransformationTypes() {
        return new TransMeta.TransformationType[]{TransMeta.TransformationType.Normal};
    }
}

