/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.parallelgzipcsv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.parallelgzipcsv.ParGzipCsvInputData;
import org.pentaho.di.trans.steps.parallelgzipcsv.ParGzipCsvInputMeta;

public class ParGzipCsvInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ParGzipCsvInputMeta.class;
    private ParGzipCsvInputMeta meta;
    private ParGzipCsvInputData data;

    public ParGzipCsvInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRowData;
        this.meta = (ParGzipCsvInputMeta)smi;
        this.data = (ParGzipCsvInputData)sdi;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            if (this.data.filenames == null) {
                this.getFilenamesFromPreviousSteps();
            }
            this.data.parallel = this.meta.isRunningInParallel() && this.data.totalNumberOfSteps > 1;
            this.data.convertRowMeta = this.data.outputRowMeta.clone();
            for (ValueMetaInterface valueMeta : this.data.convertRowMeta.getValueMetaList()) {
                valueMeta.setStorageType(1);
            }
            this.data.filenameFieldIndex = -1;
            if (!Const.isEmpty((String)this.meta.getFilenameField()) && this.meta.isIncludingFilename()) {
                this.data.filenameFieldIndex = this.meta.getInputFields().length;
            }
            this.data.rownumFieldIndex = -1;
            if (!Const.isEmpty((String)this.meta.getRowNumField())) {
                this.data.rownumFieldIndex = this.meta.getInputFields().length;
                if (this.data.filenameFieldIndex >= 0) {
                    ++this.data.rownumFieldIndex;
                }
            }
            boolean opened = false;
            while (this.data.filenr < this.data.filenames.length) {
                if (!this.openNextFile()) continue;
                opened = true;
                break;
            }
            if (!opened) {
                this.setOutputDone();
                return false;
            }
        }
        if ((outputRowData = this.readOneRow(true)) == null) {
            if (this.skipToNextBlock()) {
                boolean opened = false;
                while (this.data.filenr < this.data.filenames.length) {
                    if (!this.openNextFile()) continue;
                    opened = true;
                    break;
                }
                if (opened) {
                    return true;
                }
                this.incrementLinesUpdated();
                this.setOutputDone();
                return false;
            }
            return true;
        }
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ParGzipCsvInput.Log.LineNumber", (String[])new String[]{Long.toString(this.getLinesInput())}));
        }
        return true;
    }

    private boolean skipToNextBlock() throws KettleException {
        if (this.data.eofReached) {
            return true;
        }
        this.data.totalBytesRead = 0L;
        ++this.data.blockNr;
        if (this.data.parallel) {
            long positionToReach = (long)this.data.blockNr * this.data.blockSize * (long)this.data.totalNumberOfSteps + (long)this.data.stepNumber * this.data.blockSize;
            long bytesToSkip = positionToReach - this.data.fileReadPosition;
            this.logBasic("Skipping " + bytesToSkip + " bytes to go to position " + positionToReach + " for step copy " + this.data.stepNumber);
            try {
                long bytesSkipped;
                long n;
                for (bytesSkipped = 0L; bytesSkipped < bytesToSkip; bytesSkipped += n) {
                    n = this.data.gzis.skip(bytesToSkip - bytesSkipped);
                    if (n > 0L) continue;
                    this.data.eofReached = true;
                    this.data.fileReadPosition += bytesSkipped;
                    return true;
                }
                this.data.fileReadPosition += bytesSkipped;
                this.clearBuffer();
                this.readOneRow(false);
                return false;
            }
            catch (IOException e) {
                throw new KettleException("Error skipping " + bytesToSkip + " bytes to the next block of data", (Throwable)e);
            }
        }
        return true;
    }

    private void getFilenamesFromPreviousSteps() throws KettleException {
        ArrayList<String> filenames = new ArrayList<String>();
        boolean firstRow = true;
        int index = -1;
        Object[] row = this.getRow();
        while (row != null) {
            if (firstRow) {
                firstRow = false;
                String filenameField = this.environmentSubstitute(this.meta.getFilenameField());
                index = this.getInputRowMeta().indexOfValue(filenameField);
                if (index < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ParGzipCsvInput.Exception.FilenameFieldNotFound", (String[])new String[]{filenameField}));
                }
            }
            String filename = this.getInputRowMeta().getString(row, index);
            filenames.add(filename);
            row = this.getRow();
        }
        this.data.filenames = filenames.toArray(new String[filenames.size()]);
        this.logBasic(BaseMessages.getString(PKG, (String)"ParGzipCsvInput.Log.ReadingFromNrFiles", (String[])new String[]{Integer.toString(this.data.filenames.length)}));
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            this.closeFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose(smi, sdi);
    }

    private boolean openNextFile() throws KettleException {
        try {
            this.closeFile();
            if (this.data.filenr >= this.data.filenames.length) {
                return false;
            }
            this.logBasic("Opening file #" + this.data.filenr + " : " + this.data.filenames[this.data.filenr]);
            FileObject fileObject = KettleVFS.getFileObject((String)this.data.filenames[this.data.filenr], (VariableSpace)this.getTransMeta());
            this.data.fis = KettleVFS.getInputStream((FileObject)fileObject);
            if (this.meta.isLazyConversionActive()) {
                this.data.binaryFilename = this.data.filenames[this.data.filenr].getBytes();
            }
            this.data.gzis = new GZIPInputStream(this.data.fis, this.data.bufferSize);
            this.clearBuffer();
            this.data.fileReadPosition = 0L;
            this.data.blockNr = 0;
            this.data.eofReached = false;
            ++this.data.filenr;
            if (this.data.parallel) {
                this.data.blockSize = 2 * this.data.bufferSize;
                long bytesToSkip = (long)this.data.stepNumber * this.data.blockSize;
                if (bytesToSkip > 0L) {
                    long bytesSkipped;
                    long n;
                    this.logBasic("Skipping " + bytesToSkip + " bytes to go to position " + bytesToSkip + " for step copy " + this.data.stepNumber);
                    for (bytesSkipped = 0L; bytesSkipped < bytesToSkip; bytesSkipped += n) {
                        n = this.data.gzis.skip(bytesToSkip - bytesSkipped);
                        if (n > 0L) continue;
                        this.data.eofReached = true;
                        return false;
                    }
                    this.data.fileReadPosition += bytesSkipped;
                    this.data.totalBytesRead = 0L;
                    this.readOneRow(false);
                } else {
                    this.data.totalBytesRead = 0L;
                    if (this.meta.isHeaderPresent()) {
                        this.readOneRow(false);
                    }
                }
            } else {
                this.data.blockSize = Long.MAX_VALUE;
                if (this.meta.isHeaderPresent()) {
                    this.readOneRow(false);
                }
            }
            if (this.meta.isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, fileObject, this.getTransMeta().getName(), this.toString());
                resultFile.setComment("File was read by a Csv input step");
                this.addResultFile(resultFile);
            }
            this.data.rowNumber = 1L;
            return true;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    private void clearBuffer() {
        this.data.startBuffer = 0;
        this.data.endBuffer = 0;
        this.data.maxBuffer = 0;
    }

    private boolean checkBufferSize() throws KettleException {
        return this.data.endBuffer >= this.data.maxBuffer && (this.data.eofReached || this.data.getMoreData());
    }

    private Object[] readOneRow(boolean doConversions) throws KettleException {
        if (this.data.totalBytesRead > this.data.blockSize) {
            return null;
        }
        try {
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int outputIndex = 0;
            boolean newLineFound = false;
            int newLines = 0;
            while (!newLineFound && outputIndex < this.meta.getInputFields().length) {
                if (this.checkBufferSize()) {
                    if (outputRowData != null && outputIndex > 0) {
                        return outputRowData;
                    }
                    return null;
                }
                boolean delimiterFound = false;
                boolean enclosureFound = false;
                int escapedEnclosureFound = 0;
                while (!delimiterFound) {
                    if (this.data.byteBuffer[this.data.endBuffer] == this.data.delimiter[0]) {
                        delimiterFound = true;
                        continue;
                    }
                    if (this.data.byteBuffer[this.data.endBuffer] == 10 || this.data.byteBuffer[this.data.endBuffer] == 13) {
                        ++this.data.endBuffer;
                        ++this.data.totalBytesRead;
                        newLines = 1;
                        if (!(this.checkBufferSize() || this.data.byteBuffer[this.data.endBuffer] != 10 && this.data.byteBuffer[this.data.endBuffer] != 13)) {
                            ++this.data.endBuffer;
                            ++this.data.totalBytesRead;
                            newLines = 2;
                            this.checkBufferSize();
                        }
                        newLineFound = true;
                        delimiterFound = true;
                        continue;
                    }
                    if (this.data.enclosure != null && this.data.byteBuffer[this.data.endBuffer] == this.data.enclosure[0]) {
                        boolean keepGoing;
                        enclosureFound = true;
                        do {
                            ++this.data.endBuffer;
                            if (this.checkBufferSize()) {
                                enclosureFound = false;
                                break;
                            }
                            boolean bl = keepGoing = this.data.byteBuffer[this.data.endBuffer] != this.data.enclosure[0];
                            if (keepGoing) continue;
                            ++this.data.endBuffer;
                            if (this.checkBufferSize()) {
                                enclosureFound = false;
                                break;
                            }
                            boolean bl2 = keepGoing = this.data.byteBuffer[this.data.endBuffer] == this.data.enclosure[0];
                            if (!keepGoing) continue;
                            ++escapedEnclosureFound;
                        } while (keepGoing);
                        if (this.data.endBuffer < this.data.bufferSize) continue;
                        newLineFound = true;
                        newLines += 2;
                        break;
                    }
                    ++this.data.endBuffer;
                    ++this.data.totalBytesRead;
                    if (!this.checkBufferSize() || this.data.endBuffer < this.data.bufferSize) continue;
                    newLineFound = true;
                    break;
                }
                int length = this.data.endBuffer - this.data.startBuffer;
                if (newLineFound && (length -= newLines) <= 0) {
                    length = 0;
                }
                if (enclosureFound) {
                    ++this.data.startBuffer;
                    if ((length -= 2) <= 0) {
                        length = 0;
                    }
                }
                if (length <= 0) {
                    length = 0;
                }
                byte[] field = new byte[length];
                System.arraycopy(this.data.byteBuffer, this.data.startBuffer, field, 0, length);
                if (escapedEnclosureFound > 0) {
                    if (this.log.isRowLevel()) {
                        this.logRowlevel("Escaped enclosures found in " + new String(field));
                    }
                    field = this.data.removeEscapedEnclosures(field, escapedEnclosureFound);
                }
                if (doConversions) {
                    if (this.meta.isLazyConversionActive()) {
                        outputRowData[outputIndex++] = field;
                    } else {
                        ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(outputIndex);
                        outputRowData[outputIndex++] = sourceValueMeta.convertBinaryStringToNativeType(field);
                    }
                } else {
                    outputRowData[outputIndex++] = null;
                }
                if (!newLineFound) {
                    ++this.data.totalBytesRead;
                }
                this.data.startBuffer = ++this.data.endBuffer;
            }
            if (!newLineFound && !this.checkBufferSize()) {
                do {
                    ++this.data.endBuffer;
                    ++this.data.totalBytesRead;
                } while (!this.checkBufferSize() && this.data.byteBuffer[this.data.endBuffer] != 10 && this.data.byteBuffer[this.data.endBuffer] != 13);
                if (!this.checkBufferSize()) {
                    while (this.data.byteBuffer[this.data.endBuffer] == 10 || this.data.byteBuffer[this.data.endBuffer] == 13) {
                        ++this.data.endBuffer;
                        ++this.data.totalBytesRead;
                        if (!this.checkBufferSize()) continue;
                    }
                }
                this.data.startBuffer = this.data.endBuffer;
            }
            if (this.meta.isIncludingFilename() && !Const.isEmpty((String)this.meta.getFilenameField())) {
                outputRowData[this.data.filenameFieldIndex] = this.meta.isLazyConversionActive() ? (Object)this.data.binaryFilename : this.data.filenames[this.data.filenr - 1];
            }
            if (this.data.isAddingRowNumber) {
                outputRowData[this.data.rownumFieldIndex] = new Long(this.data.rowNumber++);
            }
            this.incrementLinesInput();
            return outputRowData;
        }
        catch (Exception e) {
            throw new KettleFileException("Exception reading line of data", (Throwable)e);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ParGzipCsvInputMeta)smi;
        this.data = (ParGzipCsvInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.bufferSize = Integer.parseInt(this.environmentSubstitute(this.meta.getBufferSize()));
            this.data.byteBuffer = new byte[0];
            if (this.getTransMeta().findNrPrevSteps(this.getStepMeta()) == 0) {
                String filename = this.environmentSubstitute(this.meta.getFilename());
                if (Const.isEmpty((String)filename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ParGzipCsvInput.MissingFilename.Message", (String[])new String[0]));
                    return false;
                }
                this.data.filenames = new String[]{filename};
            } else {
                this.data.filenames = null;
                this.data.filenr = 0;
            }
            this.data.delimiter = this.environmentSubstitute(this.meta.getDelimiter()).getBytes();
            this.data.enclosure = (byte[])(Const.isEmpty((String)this.meta.getEnclosure()) ? null : this.environmentSubstitute(this.meta.getEnclosure()).getBytes());
            boolean bl = this.data.isAddingRowNumber = !Const.isEmpty((String)this.meta.getRowNumField());
            if (this.meta.isRunningInParallel()) {
                this.data.stepNumber = this.getUniqueStepNrAcrossSlaves();
                this.data.totalNumberOfSteps = this.getUniqueStepCountAcrossSlaves();
            }
            return true;
        }
        return false;
    }

    public void closeFile() throws KettleException {
        try {
            if (this.data.gzis != null) {
                this.data.gzis.close();
            }
            if (this.data.fis != null) {
                this.incrementLinesUpdated();
                this.data.fis.close();
            }
        }
        catch (IOException e) {
            throw new KettleException("Unable to close file '" + this.data.filenames[this.data.filenr - 1], (Throwable)e);
        }
    }
}

