/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforcedelete;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.salesforcedelete.SalesforceDelete;
import org.pentaho.di.trans.steps.salesforcedelete.SalesforceDeleteData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SalesforceDeleteMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SalesforceDeleteMeta.class;
    private String targeturl;
    private String username;
    private String password;
    private String module;
    private String DeleteField;
    private String batchSize;
    private String timeout;
    private boolean useCompression;
    private boolean rollbackAllChangesOnError;

    public boolean isRollbackAllChangesOnError() {
        return this.rollbackAllChangesOnError;
    }

    public void setRollbackAllChangesOnError(boolean rollbackAllChangesOnError) {
        this.rollbackAllChangesOnError = rollbackAllChangesOnError;
    }

    public boolean isUsingCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public void setTimeOut(String TimeOut) {
        this.timeout = TimeOut;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String user_name) {
        this.username = user_name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setDeleteField(String DeleteField) {
        this.DeleteField = DeleteField;
    }

    public String getDeleteField() {
        return this.DeleteField;
    }

    public void setBatchSize(String value) {
        this.batchSize = value;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public int getBatchSizeInt() {
        return Const.toInt((String)this.batchSize, (int)10);
    }

    public String getTargetURL() {
        return this.targeturl;
    }

    public void setTargetURL(String urlvalue) {
        this.targeturl = urlvalue;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        SalesforceDeleteMeta retval = (SalesforceDeleteMeta)super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"targeturl", (String)this.targeturl));
        retval.append("    " + XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append("    " + XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password), (boolean)false, (String[])new String[0]));
        retval.append("    " + XMLHandler.addTagValue((String)"module", (String)this.module));
        retval.append("    " + XMLHandler.addTagValue((String)"DeleteField", (String)this.DeleteField));
        retval.append("    " + XMLHandler.addTagValue((String)"batchSize", (String)this.batchSize));
        retval.append("    " + XMLHandler.addTagValue((String)"timeout", (String)this.timeout));
        retval.append("    " + XMLHandler.addTagValue((String)"useCompression", (boolean)this.useCompression));
        retval.append("    " + XMLHandler.addTagValue((String)"rollbackAllChangesOnError", (boolean)this.rollbackAllChangesOnError));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.targeturl = XMLHandler.getTagValue((Node)stepnode, (String)"targeturl");
            this.username = XMLHandler.getTagValue((Node)stepnode, (String)"username");
            this.password = XMLHandler.getTagValue((Node)stepnode, (String)"password");
            if (this.password != null && this.password.startsWith("Encrypted")) {
                this.password = Encr.decryptPassword((String)this.password.replace("Encrypted", "").replace(" ", ""));
            }
            this.module = XMLHandler.getTagValue((Node)stepnode, (String)"module");
            this.DeleteField = XMLHandler.getTagValue((Node)stepnode, (String)"DeleteField");
            this.batchSize = XMLHandler.getTagValue((Node)stepnode, (String)"batchSize");
            this.useCompression = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useCompression"));
            this.timeout = XMLHandler.getTagValue((Node)stepnode, (String)"timeout");
            this.rollbackAllChangesOnError = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rollbackAllChangesOnError"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.targeturl = "https://www.salesforce.com/services/Soap/u/21.0";
        this.password = "";
        this.module = "Account";
        this.DeleteField = null;
        this.batchSize = "10";
        this.useCompression = false;
        this.rollbackAllChangesOnError = false;
        this.timeout = "60000";
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.targeturl = rep.getStepAttributeString(id_step, "targeturl");
            this.module = rep.getStepAttributeString(id_step, "module");
            this.DeleteField = rep.getStepAttributeString(id_step, "DeleteField");
            this.username = rep.getStepAttributeString(id_step, "username");
            this.password = rep.getStepAttributeString(id_step, "password");
            this.batchSize = rep.getStepAttributeString(id_step, "batchSize");
            this.useCompression = rep.getStepAttributeBoolean(id_step, "useCompression");
            this.timeout = rep.getStepAttributeString(id_step, "timeout");
            this.rollbackAllChangesOnError = rep.getStepAttributeBoolean(id_step, "rollbackAllChangesOnError");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "targeturl", this.targeturl);
            rep.saveStepAttribute(id_transformation, id_step, "batchSize", this.batchSize);
            rep.saveStepAttribute(id_transformation, id_step, "module", this.module);
            rep.saveStepAttribute(id_transformation, id_step, "DeleteField", this.DeleteField);
            rep.saveStepAttribute(id_transformation, id_step, "username", this.username);
            rep.saveStepAttribute(id_transformation, id_step, "password", this.password);
            rep.saveStepAttribute(id_transformation, id_step, "useCompression", this.useCompression);
            rep.saveStepAttribute(id_transformation, id_step, "timeout", this.timeout);
            rep.saveStepAttribute(id_transformation, id_step, "rollbackAllChangesOnError", this.rollbackAllChangesOnError);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.targeturl) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.CheckResult.NoURL", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.CheckResult.URLOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.username) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.CheckResult.NoUsername", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.CheckResult.UsernameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.module) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.CheckResult.NoModule", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.CheckResult.ModuleOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SalesforceDelete(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SalesforceDeleteData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

