/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipwriter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipContentItem;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipRepository;

public class ZipEntryOutputStream
extends OutputStream {
    private ByteArrayOutputStream outputStream;
    private DeflaterOutputStream deflaterOutputStream;
    private boolean closed;
    private ZipContentItem item;
    private CRC32 crc32;
    private long size;
    private Deflater deflater;

    public ZipEntryOutputStream(ZipContentItem item) {
        if (item == null) {
            throw new NullPointerException();
        }
        this.item = item;
        this.outputStream = new ByteArrayOutputStream();
        this.deflater = new Deflater(RepositoryUtilities.getZipLevel(item));
        this.deflaterOutputStream = new DeflaterOutputStream((OutputStream)this.outputStream, this.deflater);
        this.crc32 = new CRC32();
        this.size = 0L;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.write(b);
        this.crc32.update(b);
        ++this.size;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.write(b, off, len);
        this.crc32.update(b, off, len);
        this.size += (long)len;
    }

    @Override
    public void close() throws IOException {
        Object version;
        if (this.closed) {
            return;
        }
        this.deflaterOutputStream.close();
        this.deflater.finish();
        this.deflater.end();
        byte[] data = this.outputStream.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        InflaterInputStream infi = new InflaterInputStream(bin);
        ZipRepository repository = (ZipRepository)this.item.getRepository();
        String contentId = (String)this.item.getContentId();
        ZipEntry zipEntry = new ZipEntry(contentId);
        Object comment = this.item.getAttribute("org.jfree.repository.zip", "comment");
        if (comment != null) {
            zipEntry.setComment(String.valueOf(comment));
        }
        if ((version = this.item.getAttribute("org.jfree.repository", "version")) instanceof Date) {
            Date date = (Date)version;
            zipEntry.setTime(date.getTime());
        }
        int zipMethod = RepositoryUtilities.getZipMethod(this.item);
        zipEntry.setCrc(this.crc32.getValue());
        if (zipMethod == 0) {
            zipEntry.setCompressedSize(this.size);
            zipEntry.setSize(this.size);
        } else {
            zipEntry.setSize(this.size);
        }
        repository.writeContent(zipEntry, infi, zipMethod, RepositoryUtilities.getZipLevel(this.item));
        infi.close();
        this.closed = true;
        this.outputStream = null;
        this.deflaterOutputStream = null;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.write(b);
        this.crc32.update(b);
        this.size += (long)b.length;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.flush();
    }
}

