/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigStatsOutputSizeReader;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.util.UriUtil;

public class FileBasedOutputSizeReader
implements PigStatsOutputSizeReader {
    private static final Log log = LogFactory.getLog(FileBasedOutputSizeReader.class);

    public boolean supports(POStore sto, Configuration conf) {
        return UriUtil.isHDFSFileOrLocalOrS3N(FileBasedOutputSizeReader.getLocationUri(sto), conf);
    }

    public long getOutputSize(POStore sto, Configuration conf) throws IOException {
        if (!this.supports(sto, conf)) {
            log.warn((Object)("'" + sto.getStoreFunc().getClass().getName() + "' is not supported by " + this.getClass().getName()));
            return -1L;
        }
        long bytes = 0L;
        Path p = new Path(FileBasedOutputSizeReader.getLocationUri(sto));
        FileSystem fs = p.getFileSystem(conf);
        FileStatus[] lst = fs.listStatus(p);
        if (lst != null) {
            for (FileStatus status : lst) {
                bytes += status.getLen();
            }
        }
        return bytes;
    }

    private static String getLocationUri(POStore sto) {
        return sto.getSFile().getFileName();
    }
}

