/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.EvalFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.StoreFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigLogger;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public final class PigHadoopLogger
implements PigLogger {
    private static Log log = LogFactory.getLog(PigHadoopLogger.class);
    private static PigHadoopLogger logger = null;
    private PigStatusReporter reporter = null;
    private boolean aggregate = false;
    private Map<Object, String> msgMap = new WeakHashMap<Object, String>();

    private PigHadoopLogger() {
    }

    public static PigHadoopLogger getInstance() {
        if (logger == null) {
            logger = new PigHadoopLogger();
        }
        return logger;
    }

    public void destroy() {
        if (this.reporter != null) {
            this.reporter.destroy();
        }
        this.reporter = null;
    }

    public void setReporter(PigStatusReporter reporter) {
        this.reporter = reporter;
    }

    public void warn(Object o, String msg, Enum warningEnum) {
        String className = o.getClass().getName();
        String displayMessage = className + "(" + warningEnum + "): " + msg;
        if (this.getAggregate()) {
            if (this.reporter != null) {
                if (this.msgMap.get(o) == null || !this.msgMap.get(o).equals(displayMessage)) {
                    log.warn((Object)displayMessage);
                    this.msgMap.put(o, displayMessage);
                }
                if (o instanceof EvalFunc || o instanceof LoadFunc || o instanceof StoreFunc) {
                    this.reporter.incrCounter(className, warningEnum.name(), 1L);
                }
                this.reporter.incrCounter(warningEnum, 1L);
            } else {
                log.warn((Object)displayMessage);
            }
        } else {
            log.warn((Object)displayMessage);
        }
    }

    public synchronized boolean getAggregate() {
        return this.aggregate;
    }

    public synchronized void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }
}

