/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapBase;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCounter;
import org.apache.pig.data.Tuple;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public class PigMapReduceCounter {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PigReduceCounter
    extends PigMapReduce.Reduce {
        private static final Log log = LogFactory.getLog(PigReduceCounter.class);
        public static String taskID;
        public static Reducer.Context context;
        public static List<PhysicalOperator> leaves;
        public static PhysicalOperator leaf;

        @Override
        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            super.setup(context);
            taskID = String.valueOf(context.getTaskAttemptID().getTaskID().getId());
            leaf = (PhysicalOperator)this.rp.getLeaves().get(0);
            while (true) {
                if (leaf instanceof POCounter) break;
                leaf = this.rp.getPredecessors(leaf).get(0);
            }
            ((POCounter)leaf).setTaskId(taskID);
            ((POCounter)leaf).resetLocalCounter();
            PigReduceCounter.context = context;
        }

        public static void incrementCounter(Long increment) {
            try {
                PigStatusReporter reporter = PigStatusReporter.getInstance();
                if (reporter != null && leaf instanceof POCounter) {
                    reporter.incrCounter("pig.rank_" + context.getJobID().toString(), taskID, increment);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Error on incrementer of PigReduceCounter");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PigMapCounter
    extends PigMapBase {
        private static final Log log = LogFactory.getLog(PigMapCounter.class);
        public static String taskID;
        public static Mapper.Context context;
        private PhysicalOperator pOperator;

        @Override
        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            taskID = String.valueOf(context.getTaskAttemptID().getTaskID().getId());
            this.pOperator = (PhysicalOperator)this.mp.getLeaves().get(0);
            while (true) {
                if (this.pOperator instanceof POCounter) break;
                this.pOperator = this.mp.getPredecessors(this.pOperator).get(0);
            }
            ((POCounter)this.pOperator).setTaskId(taskID);
            ((POCounter)this.pOperator).resetLocalCounter();
        }

        @Override
        public void collect(Mapper.Context context, Tuple tuple) throws InterruptedException, IOException {
            context.write(null, (Object)tuple);
            try {
                PigStatusReporter reporter = PigStatusReporter.getInstance();
                if (reporter != null) {
                    reporter.incrCounter("pig.rank_" + context.getJobID().toString(), taskID, 1L);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Error on incrementer of PigMapCounter");
            }
        }
    }
}

