/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.Iterator;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeMax
extends EvalFunc<DateTime>
implements Algebraic,
Accumulator<DateTime> {
    private DateTime intermediateMax = null;

    @Override
    public DateTime exec(Tuple input) throws IOException {
        return DateTimeMax.max(input);
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    protected static DateTime max(Tuple input) throws ExecException {
        Tuple t;
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        Iterator<Tuple> it = values.iterator();
        DateTime curMax = null;
        while (curMax == null && it.hasNext()) {
            t = it.next();
            curMax = (DateTime)t.get(0);
        }
        while (it.hasNext()) {
            t = it.next();
            try {
                DateTime dt = (DateTime)t.get(0);
                if (dt == null || !dt.isAfter(curMax)) continue;
                curMax = dt;
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing max of datetime.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        return curMax;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 30));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            DateTime curMax = DateTimeMax.max(b);
            if (curMax == null) {
                return;
            }
            if (this.intermediateMax == null || curMax.isAfter(this.intermediateMax)) {
                this.intermediateMax = curMax;
            }
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing max in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateMax = null;
    }

    @Override
    public DateTime getValue() {
        return this.intermediateMax;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Final
    extends EvalFunc<DateTime> {
        @Override
        public DateTime exec(Tuple input) throws IOException {
            try {
                return DateTimeMax.max(input);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing max in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Intermediate
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(DateTimeMax.max(input));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing max in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Initial
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag bg = (DataBag)input.get(0);
                DateTime dt = null;
                if (bg.iterator().hasNext()) {
                    Tuple tp = bg.iterator().next();
                    dt = (DateTime)tp.get(0);
                }
                return tfact.newTuple(dt);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing max in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }
}

