/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.IndexableLoadFunc;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.io.ReadToEndLoader;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.util.ObjectSerializer;

public class DefaultIndexableLoader
extends LoadFunc
implements IndexableLoadFunc {
    private static final Log LOG = LogFactory.getLog(DefaultIndexableLoader.class);
    private String indexFile;
    private String indexFileLoadFuncSpec;
    private LoadFunc loader;
    private LinkedList<Tuple> index;
    private FuncSpec rightLoaderFuncSpec;
    private String scope;
    private Tuple dummyTuple = null;
    private transient TupleFactory mTupleFactory;
    private String inpLocation;

    public DefaultIndexableLoader(String loaderFuncSpec, String indexFile, String indexFileLoadFuncSpec, String scope, String inputLocation) {
        this.rightLoaderFuncSpec = new FuncSpec(loaderFuncSpec);
        this.indexFile = indexFile;
        this.indexFileLoadFuncSpec = indexFileLoadFuncSpec;
        this.scope = scope;
        this.inpLocation = inputLocation;
    }

    public void seekNear(Tuple keys) throws IOException {
        Tuple matchedEntry;
        this.mTupleFactory = TupleFactory.getInstance();
        Tuple firstLeftKey = keys.size() == 1 ? keys.get(0) : keys;
        POLoad ld = new POLoad(this.genKey(), new FileSpec(this.indexFile, new FuncSpec(this.indexFileLoadFuncSpec)));
        Properties props = ConfigurationUtil.getLocalFSProperties();
        PigContext pc = new PigContext(ExecType.LOCAL, props);
        ld.setPc(pc);
        this.index = new LinkedList();
        Result res = ld.getNextTuple();
        while (res.returnStatus != 3) {
            this.index.offer((Tuple)res.result);
            res = ld.getNextTuple();
        }
        Tuple prevIdxEntry = null;
        while (true) {
            Object extractedKey;
            Tuple curIdxEntry;
            if (null == (curIdxEntry = this.index.poll())) {
                matchedEntry = prevIdxEntry;
                if (prevIdxEntry == null || (extractedKey = this.extractKeysFromIdxTuple(prevIdxEntry)) == null) break;
                this.index.add(prevIdxEntry);
                break;
            }
            extractedKey = this.extractKeysFromIdxTuple(curIdxEntry);
            if (extractedKey == null) {
                prevIdxEntry = curIdxEntry;
                continue;
            }
            if (((Comparable)extractedKey).compareTo(firstLeftKey) >= 0) {
                this.index.addFirst(curIdxEntry);
                if (null == prevIdxEntry) {
                    matchedEntry = curIdxEntry;
                    break;
                }
                matchedEntry = prevIdxEntry;
                this.index.addFirst(prevIdxEntry);
                break;
            }
            prevIdxEntry = curIdxEntry;
        }
        if (matchedEntry == null) {
            LOG.warn((Object)"Empty index file: input directory is empty");
        } else {
            Object extractedKey = this.extractKeysFromIdxTuple(matchedEntry);
            if (extractedKey != null) {
                Class<?> idxKeyClass = extractedKey.getClass();
                if (!firstLeftKey.getClass().equals(idxKeyClass)) {
                    int errCode = 2166;
                    String errMsg = "Key type mismatch. Found key of type " + firstLeftKey.getClass().getCanonicalName() + " on left side. But, found key of type " + idxKeyClass.getCanonicalName() + " in index built for right side.";
                    throw new ExecException(errMsg, errCode, 4);
                }
            }
        }
        int[] splitsAhead = new int[this.index.size()];
        int splitsAheadIdx = 0;
        for (Tuple t : this.index) {
            splitsAhead[splitsAheadIdx++] = (Integer)t.get(t.size() - 1);
        }
        this.initRightLoader(splitsAhead);
    }

    private void initRightLoader(int[] splitsToBeRead) throws IOException {
        PigContext pc = (PigContext)ObjectSerializer.deserialize(((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.pigContext"));
        Configuration conf = ConfigurationUtil.toConfiguration(pc.getProperties());
        if (System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
            conf.set("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        this.loader = new ReadToEndLoader((LoadFunc)PigContext.instantiateFuncFromSpec(this.rightLoaderFuncSpec), conf, this.inpLocation, splitsToBeRead);
    }

    private Object extractKeysFromIdxTuple(Tuple idxTuple) throws ExecException {
        int idxTupSize = idxTuple.size();
        if (idxTupSize == 3) {
            return idxTuple.get(0);
        }
        int numColsInKey = idxTupSize - 2;
        ArrayList<Object> list = new ArrayList<Object>(numColsInKey);
        for (int i = 0; i < numColsInKey; ++i) {
            list.add(idxTuple.get(i));
        }
        return this.mTupleFactory.newTupleNoCopy(list);
    }

    private OperatorKey genKey() {
        return new OperatorKey(this.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.scope));
    }

    public Tuple getNext() throws IOException {
        Tuple t = this.loader.getNext();
        return t;
    }

    public void close() throws IOException {
    }

    public void initialize(Configuration conf) throws IOException {
    }

    public InputFormat getInputFormat() throws IOException {
        throw new UnsupportedOperationException();
    }

    public LoadCaster getLoadCaster() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void prepareToRead(RecordReader reader, PigSplit split) {
        throw new UnsupportedOperationException();
    }

    public void setLocation(String location, Job job) throws IOException {
    }

    public void setIndexFile(String indexFile) {
        this.indexFile = indexFile;
    }
}

