/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.format;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.StyleEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilter;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilterFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;

public final class BoldAction
extends AbstractElementSelectionAction
implements ToggleStateAction {
    private ReportModelEventFilter eventFilter;

    public BoldAction() {
        this.putValue("SwingSelectedKey", Boolean.FALSE);
        this.putValue("Name", ActionMessages.getString("BoldAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("BoldAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("BoldAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getBoldCommand());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("BoldAction.Accelerator"));
        this.eventFilter = new ReportModelEventFilterFactory().createStyleFilter(TextStyleKeys.BOLD);
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
        if (this.eventFilter.isFilteredEvent(event)) {
            this.updateSelection();
        }
    }

    @Override
    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    @Override
    protected void updateSelection() {
        boolean selected;
        super.updateSelection();
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        if (visualElements.isEmpty()) {
            selected = false;
        } else {
            selected = true;
            for (Element visualElement : visualElements) {
                selected &= visualElement.getStyle().getBooleanStyleProperty(TextStyleKeys.BOLD);
            }
        }
        this.setSelected(selected);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        Boolean value = null;
        ArrayList<StyleEditUndoEntry> undos = new ArrayList<StyleEditUndoEntry>();
        for (Element element : visualElements) {
            ElementStyleSheet styleSheet = element.getStyle();
            if (value == null) {
                value = styleSheet.getBooleanStyleProperty(TextStyleKeys.BOLD) ? Boolean.FALSE : Boolean.TRUE;
            }
            undos.add(StyleEditUndoEntry.createConditional((ReportElement)element, TextStyleKeys.BOLD, value));
            styleSheet.setStyleProperty(TextStyleKeys.BOLD, (Object)value);
        }
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("BoldAction.UndoName", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
    }
}

