/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.layout;

import java.awt.event.ActionEvent;
import java.util.List;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntryBuilder;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilter;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilterFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;

public abstract class LayoutAction
extends AbstractElementSelectionAction
implements ToggleStateAction {
    private ReportModelEventFilter eventFilter;
    private String prefix;
    private String layoutMode;

    public LayoutAction(String prefix, String layoutMode) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (layoutMode == null) {
            throw new NullPointerException();
        }
        this.prefix = prefix;
        this.layoutMode = layoutMode;
        this.eventFilter = new ReportModelEventFilterFactory().createStyleFilter(BandStyleKeys.LAYOUT);
        this.putValue("Name", ActionMessages.getString(prefix + ".Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString(prefix + ".Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic(prefix + ".Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke(prefix + ".Accelerator"));
        this.putValue("SwingSelectedKey", Boolean.FALSE);
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
        if (this.eventFilter.isFilteredEvent(event)) {
            this.updateSelection();
        }
    }

    @Override
    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    @Override
    protected void updateSelection() {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Band> visualElements = model.getSelectedElementsOfType(Band.class);
        if (visualElements.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        Element first = (Element)visualElements.get(0);
        this.setSelected(this.layoutMode.equals(first.getStyle().getStyleProperty(BandStyleKeys.LAYOUT, (Object)"canvas")));
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Band> visualElements = model.getSelectedElementsOfType(Band.class);
        MassElementStyleUndoEntryBuilder builder = new MassElementStyleUndoEntryBuilder(visualElements);
        for (Band object : visualElements) {
            object.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)this.layoutMode);
        }
        MassElementStyleUndoEntry massElementStyleUndoEntry = builder.finish();
        this.getActiveContext().getUndo().addChange(ActionMessages.getString(this.prefix + ".UndoName", new Object[0]), massElementStyleUndoEntry);
    }
}

