/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report.preview;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.util.ExternalToolLauncher;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewParametersDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.validator.ReportStructureValidator;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelExportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FlowReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.FlowExcelOutputProcessor;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public final class PreviewExcelAction
extends AbstractReportContextAction {
    public PreviewExcelAction() {
        this.putValue("Name", ActionMessages.getString("PreviewExcelAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("PreviewExcelAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("PreviewExcelAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("PreviewExcelAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getPreviewXLSIcon());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getActiveContext() == null) {
            return;
        }
        MasterReport reportElement = (MasterReport)this.getActiveContext().getContextRoot();
        Component parent = this.getReportDesignerContext().getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        if (PreviewParametersDialog.process((Window)window, (MasterReport)reportElement)) {
            ReportProgressDialog dialog = window instanceof JDialog ? new ReportProgressDialog((Dialog)((JDialog)window)) : (window instanceof JFrame ? new ReportProgressDialog((Frame)((JFrame)window)) : new ReportProgressDialog());
            Thread t = new Thread(new ExportTask(reportElement, dialog));
            t.setDaemon(true);
            t.start();
        }
    }

    private static class ExportTask
    implements Runnable {
        private MasterReport report;
        private ReportProgressDialog progressDialog;

        private ExportTask(MasterReport report, ReportProgressDialog progressDialog) {
            this.report = report;
            this.progressDialog = progressDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                File tempFile = File.createTempFile("report-designer-preview", ".xls");
                tempFile.deleteOnExit();
                FileOutputStream fout = new FileOutputStream(tempFile);
                try {
                    FastExcelExportProcessor reportProcessor;
                    BufferedOutputStream bout = new BufferedOutputStream(fout);
                    ReportStructureValidator validator = new ReportStructureValidator();
                    if (!validator.isValidForFastProcessing(this.report)) {
                        FlowExcelOutputProcessor target = new FlowExcelOutputProcessor(this.report.getConfiguration(), (OutputStream)bout, this.report.getResourceManager());
                        target.setUseXlsxFormat(false);
                        reportProcessor = new FlowReportProcessor(this.report, (OutputProcessor)target);
                    } else {
                        reportProcessor = new FastExcelExportProcessor(this.report, (OutputStream)bout, false);
                    }
                    reportProcessor.addReportProgressListener((ReportProgressListener)this.progressDialog);
                    this.progressDialog.setVisibleInEDT(true);
                    reportProcessor.processReport();
                    reportProcessor.close();
                    bout.flush();
                    reportProcessor.removeReportProgressListener((ReportProgressListener)this.progressDialog);
                }
                finally {
                    fout.close();
                }
                this.progressDialog.setVisibleInEDT(false);
                ExternalToolLauncher.openXLS(tempFile);
            }
            catch (Exception e1) {
                UncaughtExceptionsModel.getInstance().addException(e1);
                this.progressDialog.dispose();
                String errorMessage = ActionMessages.getString("PreviewReport.Error.Text", new Object[0]);
                String errorTitle = ActionMessages.getString("PreviewReport.Error.Title", new Object[0]);
                ExceptionDialog.showExceptionDialog((Component)this.progressDialog.getParent(), (String)errorTitle, (String)errorMessage, (Exception)e1);
            }
        }
    }
}

