/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.crosstab;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabDetail;
import org.pentaho.reporting.engine.classic.core.metadata.propertyeditors.AggregationTypePropertyEditor;
import org.pentaho.reporting.libraries.designtime.swing.bulk.BulkDataProvider;
import org.pentaho.reporting.libraries.designtime.swing.table.PropertyTableModel;

public class CrosstabDetailTableModel
extends AbstractTableModel
implements BulkDataProvider,
PropertyTableModel {
    private ArrayList<CrosstabDetail> data = new ArrayList();

    public void setData(CrosstabDetail[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data.clear();
        this.data.addAll(Arrays.asList(data));
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CrosstabDetail crosstabDimension = this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return crosstabDimension.getField();
            }
            case 1: {
                return crosstabDimension.getAggregation();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        CrosstabDetail crosstabDetail = this.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                crosstabDetail.setAggregation((Class)value);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Class.class;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Messages.getString("CrosstabDetailTableModel.Field", new Object[0]);
            }
            case 1: {
                return Messages.getString("CrosstabDetailTableModel.Aggregation", new Object[0]);
            }
        }
        throw new IllegalStateException();
    }

    public void add(CrosstabDetail o) {
        this.data.add(o);
        this.fireTableDataChanged();
    }

    public void add(int idx, CrosstabDetail item) {
        this.data.add(idx, item);
        this.fireTableDataChanged();
    }

    public CrosstabDetail get(int index) {
        return this.data.get(index);
    }

    public void remove(int index) {
        this.data.remove(index);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    public CrosstabDetail[] toArray() {
        return this.data.toArray(new CrosstabDetail[this.data.size()]);
    }

    public int size() {
        return this.getRowCount();
    }

    public int getBulkDataSize() {
        return this.getRowCount();
    }

    public Object[] getBulkData() {
        return this.toArray();
    }

    public void setBulkData(Object[] data) {
        this.data.clear();
        for (int i = 0; i < data.length; ++i) {
            Object o = data[i];
            this.data.add((CrosstabDetail)o);
        }
        this.fireTableDataChanged();
    }

    public Class getClassForCell(int row, int col) {
        return this.getColumnClass(col);
    }

    public PropertyEditor getEditorForCell(int row, int column) {
        if (column == 1) {
            return new AggregationTypePropertyEditor();
        }
        return null;
    }
}

