/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.pentaho.reporting.designer.core.editor.drilldown.model.ParameterSelection;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class Parameter {
    public static final String CORE_NAMESPACE = "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core";
    private ArrayList<ParameterSelection> selections;
    private String name;
    private String type;
    private HashMap<String, HashMap<String, String>> attributes;
    private boolean strict;
    private boolean multiSelect;
    private boolean mandatory;
    private String timezoneHint;

    public Parameter(String name) {
        this.name = name;
        this.selections = new ArrayList();
        this.attributes = new HashMap();
    }

    public void addSelection(ParameterSelection selection) {
        this.selections.add(selection);
    }

    public boolean hasValues() {
        return !this.selections.isEmpty();
    }

    public String getTimezoneHint() {
        return this.timezoneHint;
    }

    public void setTimezoneHint(String timezoneHint) {
        this.timezoneHint = timezoneHint;
    }

    public void setAttribute(String namespace, String name, String value) {
        HashMap<String, String> hashMap = this.attributes.get(namespace);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.attributes.put(namespace, hashMap);
        }
        hashMap.put(name, value);
    }

    public String getAttribute(String namespace, String name) {
        HashMap<String, String> hashMap = this.attributes.get(namespace);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(name);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        String attribute = this.getAttribute(CORE_NAMESPACE, "label");
        if (StringUtils.isEmpty((String)attribute)) {
            return this.name;
        }
        return attribute;
    }

    public String getTooltip() {
        return this.getAttribute(CORE_NAMESPACE, "tooltip");
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public String getAttribute(String name) {
        return this.getAttribute(CORE_NAMESPACE, name);
    }

    public List<ParameterSelection> getSelections() {
        return this.selections;
    }

    public boolean isHidden() {
        return "true".equals(this.getAttribute(CORE_NAMESPACE, "hidden"));
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSelections(ParameterSelection[] selections) {
        this.selections.addAll(Arrays.asList(selections));
    }
}

