/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.expressions;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.bsf.BSFManager;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.expressions.EditorExpressionsMessages;
import org.pentaho.reporting.designer.core.editor.expressions.ScriptingExpressionEditor;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.misc.bsf.BSFExpression;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;
import org.pentaho.reporting.libraries.designtime.swing.VerticalLayout;

public class BSFScriptingExpressionEditor
extends ScriptingExpressionEditor {
    private BSFExpression bshExpression;
    private JComboBox languageField;

    public BSFScriptingExpressionEditor() {
        this.setSyntaxEditingStyle("text/java");
        this.languageField = new SmartComboBox(new DefaultComboBoxModel<String>(InternalBSFManager.getRegisteredLanguages()));
        this.languageField.getModel().addListDataListener(new UpdateLanguageHandler());
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new VerticalLayout(5, 3));
        panel.add(new JLabel(EditorExpressionsMessages.getString("BSFScriptingExpressionEditor.Language")));
        panel.add(this.languageField);
        this.getPanel().add((Component)panel, "North");
    }

    protected String getLanguage() {
        return (String)this.languageField.getSelectedItem();
    }

    @Override
    public void initialize(Expression expression, ReportDesignerContext context) {
        this.bshExpression = (BSFExpression)expression;
        this.setText(this.bshExpression.getExpression());
        this.languageField.setSelectedItem(this.bshExpression.getLanguage());
    }

    @Override
    public void stopEditing() {
        this.bshExpression.setLanguage((String)this.languageField.getSelectedItem());
        this.bshExpression.setExpression(this.getText());
    }

    private String mapLanguageToSyntaxHighlighting(String language) {
        if ("beanshell".equals(language)) {
            return "text/java";
        }
        if ("groovy".equals(language)) {
            return "text/groovy";
        }
        if ("javascript".equals(language)) {
            return "text/javascript";
        }
        if ("jython".equals(language)) {
            return "text/python";
        }
        if ("xslt".equals(language)) {
            return "text/xml";
        }
        return "text/plain";
    }

    private class UpdateLanguageHandler
    implements ListDataListener {
        private UpdateLanguageHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.updateComponents();
        }

        private void updateComponents() {
            BSFScriptingExpressionEditor.this.setSyntaxEditingStyle(BSFScriptingExpressionEditor.this.mapLanguageToSyntaxHighlighting((String)BSFScriptingExpressionEditor.this.languageField.getSelectedItem()));
        }
    }

    private static class InternalBSFManager
    extends BSFManager {
        private InternalBSFManager() {
        }

        public static String[] getRegisteredLanguages() {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry entry : registeredEngines.entrySet()) {
                String lang = (String)entry.getKey();
                String className = (String)entry.getValue();
                try {
                    Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                    list.add(lang);
                }
                catch (Throwable t) {}
            }
            return list.toArray(new String[list.size()]);
        }
    }
}

