/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.drag;

import java.awt.geom.Point2D;
import java.util.List;
import org.pentaho.reporting.designer.core.editor.report.drag.AbstractMouseDragOperation;
import org.pentaho.reporting.designer.core.editor.report.snapping.SnapPositionsModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class MoveDragOperation
extends AbstractMouseDragOperation {
    private long snapThreshold = WorkspaceSettings.getInstance().getSnapThreshold();

    public MoveDragOperation(List<Element> selectedVisualElements, Point2D originPoint, SnapPositionsModel horizontalSnapModel, SnapPositionsModel verticalSnapModel) {
        super(selectedVisualElements, originPoint, horizontalSnapModel, verticalSnapModel);
    }

    @Override
    public void update(Point2D normalizedPoint, double zoomFactor) {
        SnapPositionsModel horizontalSnapModel = this.getHorizontalSnapModel();
        SnapPositionsModel verticalSnapModel = this.getVerticalSnapModel();
        Element[] selectedVisualElements = this.getSelectedVisualElements();
        long originPointX = this.getOriginPointX();
        long originPointY = this.getOriginPointY();
        long[] elementXCoords = this.getElementX();
        long[] elementYCoords = this.getElementY();
        long[] elementWidth = this.getElementWidth();
        long[] elementHeight = this.getElementHeight();
        long px = StrictGeomUtility.toInternalValue((double)normalizedPoint.getX());
        long py = StrictGeomUtility.toInternalValue((double)normalizedPoint.getY());
        long dx = px - originPointX;
        long dy = py - originPointY;
        for (int i = 0; i < selectedVisualElements.length; ++i) {
            long localYPosition;
            long percentage;
            long percentage2;
            long snapPosition2;
            long snapPosition;
            long parentBase;
            float position;
            long snapPosition22;
            long snapPosition3;
            Element element = selectedVisualElements[i];
            if (element instanceof RootLevelBand) continue;
            ElementStyleSheet styleSheet = element.getStyle();
            double elementX = styleSheet.getDoubleStyleProperty(ElementStyleKeys.POS_X, 0.0);
            double elementY = styleSheet.getDoubleStyleProperty(ElementStyleKeys.POS_Y, 0.0);
            Section parent = element.getParentSection();
            if (parent == null) {
                throw new IllegalStateException("Parent has been removed, but the drag operation was not finished: " + element);
            }
            CachedLayoutData data = ModelUtility.getCachedLayoutData((Element)parent);
            long layoutedParentX = data.getX() + data.getPaddingX();
            long layoutedParentY = data.getY() + data.getPaddingY();
            long targetPositionX = elementXCoords[i] + dx;
            long targetPositionY = elementYCoords[i] + dy;
            if (elementX >= 0.0) {
                snapPosition3 = horizontalSnapModel.getNearestSnapPosition(targetPositionX, element.getObjectID());
                if (Math.abs(snapPosition3 - targetPositionX) > this.snapThreshold) {
                    long targetPositionX2 = targetPositionX + elementWidth[i];
                    snapPosition22 = horizontalSnapModel.getNearestSnapPosition(targetPositionX2, element.getObjectID());
                    if (Math.abs(snapPosition22 - targetPositionX2) < this.snapThreshold) {
                        long snapX = snapPosition22 - elementWidth[i];
                        long localXPosition = Math.max(0L, snapX - layoutedParentX);
                        position = (float)StrictGeomUtility.toExternalValue((long)localXPosition);
                        styleSheet.setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(position));
                    } else {
                        long localXPosition = Math.max(0L, targetPositionX - layoutedParentX);
                        float position2 = (float)StrictGeomUtility.toExternalValue((long)localXPosition);
                        styleSheet.setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(position2));
                    }
                } else {
                    long localXPosition = Math.max(0L, snapPosition3 - layoutedParentX);
                    float position3 = (float)StrictGeomUtility.toExternalValue((long)localXPosition);
                    styleSheet.setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(position3));
                }
            } else {
                parentBase = data.getWidth();
                if (parentBase > 0L) {
                    snapPosition = horizontalSnapModel.getNearestSnapPosition(targetPositionX, element.getObjectID());
                    if (Math.abs(snapPosition - targetPositionX) > this.snapThreshold) {
                        long targetPositionX2 = targetPositionX + elementWidth[i];
                        snapPosition2 = horizontalSnapModel.getNearestSnapPosition(targetPositionX2, element.getObjectID());
                        if (Math.abs(snapPosition2 - targetPositionX2) < this.snapThreshold) {
                            long snapX = snapPosition2 - elementWidth[i];
                            long localXPosition = Math.max(0L, snapX - layoutedParentX);
                            percentage2 = StrictGeomUtility.toInternalValue((double)(localXPosition * 100L / parentBase));
                            styleSheet.setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage2))));
                        } else {
                            long localXPosition = Math.max(0L, targetPositionX - layoutedParentX);
                            long percentage3 = StrictGeomUtility.toInternalValue((double)(localXPosition * 100L / parentBase));
                            styleSheet.setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage3))));
                        }
                    } else {
                        long localXPosition = Math.max(0L, snapPosition - layoutedParentX);
                        percentage = StrictGeomUtility.toInternalValue((double)(localXPosition * 100L / parentBase));
                        styleSheet.setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage))));
                    }
                }
            }
            if (elementY >= 0.0) {
                snapPosition3 = verticalSnapModel.getNearestSnapPosition(targetPositionY, element.getObjectID());
                if (Math.abs(snapPosition3 - targetPositionY) > this.snapThreshold) {
                    long targetPositionY2 = targetPositionY + elementHeight[i];
                    snapPosition22 = horizontalSnapModel.getNearestSnapPosition(targetPositionY2, element.getObjectID());
                    if (Math.abs(snapPosition22 - targetPositionY2) < this.snapThreshold) {
                        long snapY = snapPosition22 - elementHeight[i];
                        localYPosition = Math.max(0L, snapY - layoutedParentY);
                        position = (float)StrictGeomUtility.toExternalValue((long)localYPosition);
                        styleSheet.setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(position));
                    } else {
                        long localYPosition2 = Math.max(0L, targetPositionY - layoutedParentY);
                        float position4 = (float)StrictGeomUtility.toExternalValue((long)localYPosition2);
                        styleSheet.setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(position4));
                    }
                } else {
                    long localYPosition3 = Math.max(0L, snapPosition3 - layoutedParentY);
                    float position5 = (float)StrictGeomUtility.toExternalValue((long)localYPosition3);
                    styleSheet.setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(position5));
                }
            } else {
                parentBase = this.isCanvasElement((Element)parent) ? data.getHeight() : data.getWidth();
                if (parentBase > 0L) {
                    snapPosition = verticalSnapModel.getNearestSnapPosition(targetPositionY, element.getObjectID());
                    if (Math.abs(snapPosition - targetPositionY) > this.snapThreshold) {
                        long targetPositionY2 = targetPositionY + elementHeight[i];
                        snapPosition2 = horizontalSnapModel.getNearestSnapPosition(targetPositionY2, element.getObjectID());
                        if (Math.abs(snapPosition2 - targetPositionY2) < this.snapThreshold) {
                            long snapY = snapPosition2 - elementHeight[i];
                            long localYPosition4 = Math.max(0L, snapY - layoutedParentY);
                            percentage2 = StrictGeomUtility.toInternalValue((double)(localYPosition4 * 100L / parentBase));
                            styleSheet.setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage2))));
                        } else {
                            localYPosition = Math.max(0L, targetPositionY - layoutedParentY);
                            long percentage4 = StrictGeomUtility.toInternalValue((double)(localYPosition * 100L / parentBase));
                            styleSheet.setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage4))));
                        }
                    } else {
                        long localYPosition5 = Math.max(0L, snapPosition - layoutedParentY);
                        percentage = StrictGeomUtility.toInternalValue((double)(localYPosition5 * 100L / parentBase));
                        styleSheet.setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage))));
                    }
                }
            }
            element.notifyNodePropertiesChanged();
        }
    }

    @Override
    public void finish() {
    }
}

