/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.elements;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.elements.InsertCrosstabGroupAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.parameters.SubReportDataSourceDialog;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditorContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.BandedSubreportEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ElementEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractRootLevelBand;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CrosstabElement;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class CrosstabConfigureHandler
implements Runnable {
    private final Component component;
    private final ReportDesignerContext designerContext;
    private final ReportDocumentContext renderContext;
    private final CrosstabElement subReport;
    private final Band parent;
    private final boolean rootband;

    public CrosstabConfigureHandler(CrosstabElement subReport, Band parent, ReportElementEditorContext dragContext, boolean rootband) {
        ArgumentNullException.validate((String)"subReport", (Object)subReport);
        ArgumentNullException.validate((String)"parent", (Object)parent);
        ArgumentNullException.validate((String)"dragContext", (Object)dragContext);
        this.subReport = subReport;
        this.parent = parent;
        this.component = dragContext.getRepresentationContainer();
        this.designerContext = dragContext.getDesignerContext();
        this.renderContext = dragContext.getRenderContext();
        this.rootband = rootband;
    }

    public CrosstabConfigureHandler(CrosstabElement subReport, Band parent, ReportDesignerContext designerContext, ReportDocumentContext renderContext) {
        ArgumentNullException.validate((String)"subReport", (Object)subReport);
        ArgumentNullException.validate((String)"parent", (Object)parent);
        ArgumentNullException.validate((String)"designerContext", (Object)designerContext);
        ArgumentNullException.validate((String)"renderContext", (Object)renderContext);
        this.subReport = subReport;
        this.parent = parent;
        this.component = designerContext.getView().getParent();
        this.designerContext = designerContext;
        this.renderContext = renderContext;
        this.rootband = parent instanceof AbstractRootLevelBand;
    }

    @Override
    public void run() {
        UndoManager undo = this.renderContext.getUndo();
        if (this.rootband) {
            int result = JOptionPane.showOptionDialog(this.component, Messages.getString("CrosstabReportElementDragHandler.BandedOrInlineSubreportQuestion", new Object[0]), Messages.getString("CrosstabReportElementDragHandler.InsertSubreport", new Object[0]), 1, -1, null, new String[]{Messages.getString("CrosstabReportElementDragHandler.Inline", new Object[0]), Messages.getString("CrosstabReportElementDragHandler.Banded", new Object[0]), Messages.getString("CrosstabReportElementDragHandler.Cancel", new Object[0])}, Messages.getString("CrosstabReportElementDragHandler.Inline", new Object[0]));
            if (result == -1 || result == 2) {
                return;
            }
            if (result == 0) {
                undo.addChange(Messages.getString("CrosstabReportElementDragHandler.UndoEntry", new Object[0]), new ElementEditUndoEntry(this.parent.getObjectID(), this.parent.getElementCount(), null, (Element)this.subReport));
                this.parent.addElement((Element)this.subReport);
            } else {
                AbstractRootLevelBand arb = (AbstractRootLevelBand)this.parent;
                undo.addChange(Messages.getString("CrosstabReportElementDragHandler.UndoEntry", new Object[0]), new BandedSubreportEditUndoEntry(this.parent.getObjectID(), arb.getSubReportCount(), null, (SubReport)this.subReport));
                arb.addSubReport((SubReport)this.subReport);
            }
        } else {
            undo.addChange(Messages.getString("CrosstabReportElementDragHandler.UndoEntry", new Object[0]), new ElementEditUndoEntry(this.parent.getObjectID(), this.parent.getElementCount(), null, (Element)this.subReport));
            this.parent.addElement((Element)this.subReport);
        }
        Window window = LibSwingUtil.getWindowAncestor((Component)this.designerContext.getView().getParent());
        AbstractReportDefinition reportDefinition = this.designerContext.getActiveContext().getReportDefinition();
        try {
            this.subReport.setDataFactory(reportDefinition.getDataFactory());
            this.subReport.getReportDefinition().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "zoom", (Object)Float.valueOf(1.5f));
            int idx = this.designerContext.addSubReport(this.designerContext.getActiveContext(), (SubReport)this.subReport);
            this.designerContext.setActiveDocument(this.designerContext.getReportRenderContext(idx));
        }
        catch (ReportDataFactoryException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
        SubReportDataSourceDialog crosstabDataSourceDialog = window instanceof Dialog ? new SubReportDataSourceDialog((Dialog)window) : (window instanceof Frame ? new SubReportDataSourceDialog((Frame)window) : new SubReportDataSourceDialog());
        String queryName = crosstabDataSourceDialog.performSelection(this.designerContext);
        if (queryName != null) {
            this.subReport.setQuery(queryName);
            InsertCrosstabGroupAction crosstabAction = new InsertCrosstabGroupAction();
            crosstabAction.setReportDesignerContext(this.designerContext);
            crosstabAction.actionPerformed(new ActionEvent(this, 1001, ""));
        }
        this.subReport.addInputParameter("*", "*");
        this.renderContext.getSelectionModel().setSelectedElements(new Object[]{this.subReport});
    }

    public static void configureDefaults(CrosstabElement visualElement) {
        visualElement.setAutoSort(Boolean.TRUE);
        visualElement.getPageHeader().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getReportHeader().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getReportFooter().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getPageFooter().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getWatermark().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
    }
}

