/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.elements;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JOptionPane;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.parameters.SubReportDataSourceDialog;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditorContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.BandedSubreportEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ElementEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractRootLevelBand;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class SubreportConfigureHandler
implements Runnable {
    private final Component component;
    private final ReportDesignerContext designerContext;
    private final ReportDocumentContext renderContext;
    private final SubReport subReport;
    private final Band parent;
    private final boolean rootband;

    public SubreportConfigureHandler(SubReport subReport, Band parent, ReportElementEditorContext dragContext, boolean rootband) {
        ArgumentNullException.validate((String)"subReport", (Object)subReport);
        ArgumentNullException.validate((String)"parent", (Object)parent);
        ArgumentNullException.validate((String)"dragContext", (Object)dragContext);
        this.subReport = subReport;
        this.parent = parent;
        this.component = dragContext.getRepresentationContainer();
        this.designerContext = dragContext.getDesignerContext();
        this.renderContext = dragContext.getRenderContext();
        this.rootband = rootband;
    }

    public SubreportConfigureHandler(SubReport subReport, Band parent, ReportDesignerContext designerContext, ReportDocumentContext renderContext) {
        ArgumentNullException.validate((String)"subReport", (Object)subReport);
        ArgumentNullException.validate((String)"parent", (Object)parent);
        ArgumentNullException.validate((String)"designerContext", (Object)designerContext);
        ArgumentNullException.validate((String)"renderContext", (Object)renderContext);
        this.subReport = subReport;
        this.parent = parent;
        this.component = designerContext.getView().getParent();
        this.designerContext = designerContext;
        this.renderContext = renderContext;
        this.rootband = parent instanceof AbstractRootLevelBand;
    }

    @Override
    public void run() {
        UndoManager undo = this.renderContext.getUndo();
        if (this.rootband) {
            int result = JOptionPane.showOptionDialog(this.component, Messages.getString("SubreportReportElementDragHandler.BandedOrInlineSubreportQuestion", new Object[0]), Messages.getString("SubreportReportElementDragHandler.InsertSubreport", new Object[0]), 1, -1, null, new String[]{Messages.getString("SubreportReportElementDragHandler.Inline", new Object[0]), Messages.getString("SubreportReportElementDragHandler.Banded", new Object[0]), Messages.getString("SubreportReportElementDragHandler.Cancel", new Object[0])}, Messages.getString("SubreportReportElementDragHandler.Inline", new Object[0]));
            if (result == -1 || result == 2) {
                return;
            }
            if (result == 0) {
                undo.addChange(Messages.getString("SubreportReportElementDragHandler.UndoEntry", new Object[0]), new ElementEditUndoEntry(this.parent.getObjectID(), this.parent.getElementCount(), null, (Element)this.subReport));
                this.parent.addElement((Element)this.subReport);
            } else {
                AbstractRootLevelBand arb = (AbstractRootLevelBand)this.parent;
                undo.addChange(Messages.getString("SubreportReportElementDragHandler.UndoEntry", new Object[0]), new BandedSubreportEditUndoEntry(this.parent.getObjectID(), arb.getSubReportCount(), null, this.subReport));
                arb.addSubReport(this.subReport);
            }
        } else {
            undo.addChange(Messages.getString("SubreportReportElementDragHandler.UndoEntry", new Object[0]), new ElementEditUndoEntry(this.parent.getObjectID(), this.parent.getElementCount(), null, (Element)this.subReport));
            this.parent.addElement((Element)this.subReport);
        }
        Window window = LibSwingUtil.getWindowAncestor((Component)this.designerContext.getView().getParent());
        AbstractReportDefinition reportDefinition = this.designerContext.getActiveContext().getReportDefinition();
        try {
            this.subReport.setDataFactory(reportDefinition.getDataFactory());
            int idx = this.designerContext.addSubReport(this.designerContext.getActiveContext(), this.subReport);
            this.designerContext.setActiveDocument(this.designerContext.getReportRenderContext(idx));
        }
        catch (ReportDataFactoryException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
        SubReportDataSourceDialog subreportDataSourceDialog = window instanceof Dialog ? new SubReportDataSourceDialog((Dialog)window) : (window instanceof Frame ? new SubReportDataSourceDialog((Frame)window) : new SubReportDataSourceDialog());
        String queryName = subreportDataSourceDialog.performSelection(this.designerContext);
        if (queryName != null) {
            this.subReport.setQuery(queryName);
        }
        this.subReport.addInputParameter("*", "*");
        this.renderContext.getSelectionModel().setSelectedElements(new Object[]{this.subReport});
    }

    public static void configureDefaults(SubReport visualElement) {
        visualElement.setAutoSort(Boolean.TRUE);
        visualElement.getRelationalGroup(0).getHeader().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getRelationalGroup(0).getFooter().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getDetailsFooter().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getDetailsHeader().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getNoDataBand().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getWatermark().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
    }
}

