/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.styles;

import java.beans.PropertyEditor;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.editor.styles.Messages;
import org.pentaho.reporting.designer.core.editor.styles.StyleDataBackend;
import org.pentaho.reporting.designer.core.util.FastPropertyEditorManager;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupedName;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.table.GroupingModel;
import org.pentaho.reporting.designer.core.util.table.TableStyle;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.ResolverStyleSheet;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public abstract class AbstractStyleTableModel<T extends StyleDataBackend>
extends AbstractTableModel
implements ElementMetaDataTableModel,
GroupingModel {
    private static final Log logger = LogFactory.getLog(AbstractStyleTableModel.class);
    private static final String[] EXTRA_FIELDS = new String[0];
    private TableStyle tableStyle = TableStyle.GROUPED;
    private T dataBackend;
    private boolean synchronous;

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    protected synchronized T getDataBackend() {
        return this.dataBackend;
    }

    protected synchronized void setDataBackend(T dataBackend) {
        this.dataBackend = dataBackend;
    }

    @Override
    public int getRowCount() {
        return this.dataBackend.getRowCount();
    }

    protected StyleMetaData getMetaData(int row) {
        return this.getDataBackend().getMetaData(row);
    }

    protected GroupingHeader getGroupings(int row) {
        return this.getDataBackend().getGroupings(row);
    }

    @Override
    public TableStyle getTableStyle() {
        return this.tableStyle;
    }

    @Override
    public void setTableStyle(TableStyle tableStyle) {
        if (tableStyle == null) {
            throw new NullPointerException();
        }
        this.tableStyle = tableStyle;
    }

    protected GroupingHeader[] reconcileState(GroupingHeader[] groupings, GroupingHeader[] oldGroupings) {
        if (oldGroupings == null) {
            return groupings;
        }
        for (int i = 0; i < groupings.length; ++i) {
            GroupingHeader oldHeader;
            GroupingHeader header = groupings[i];
            if (header == null || (oldHeader = this.findFirstOccurrenceOfHeaderTitle(oldGroupings, header.getHeaderText())) == null) continue;
            header.setCollapsed(oldHeader.isCollapsed());
        }
        return groupings;
    }

    private GroupingHeader findFirstOccurrenceOfHeaderTitle(GroupingHeader[] headerArray, String headerTitle) {
        for (GroupingHeader header : headerArray) {
            if (header == null || !ObjectUtilities.equal((Object)header.getHeaderText(), (Object)headerTitle)) continue;
            return header;
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Messages.getString("StyleTableModel.NameColumn", new Object[0]);
            }
            case 1: {
                return Messages.getString("StyleTableModel.InheritColumn", new Object[0]);
            }
            case 2: {
                return Messages.getString("StyleTableModel.ValueColumn", new Object[0]);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        StyleMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return this.getGroupings(rowIndex);
        }
        switch (columnIndex) {
            case 0: {
                return new GroupedName((MetaData)metaData);
            }
            case 1: {
                return this.computeInheritValue(metaData, rowIndex);
            }
            case 2: {
                return this.computeFullValue(metaData, rowIndex);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        StyleMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return false;
        }
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: {
                return true;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        StyleMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                return;
            }
            case 1: {
                if (!Boolean.TRUE.equals(aValue) || !this.defineFullValue(metaData, null)) break;
                this.getDataBackend().clearCache(rowIndex);
                this.fireTableDataChanged();
                break;
            }
            case 2: {
                if (!this.defineFullValue(metaData, aValue)) break;
                this.getDataBackend().clearCache(rowIndex);
                this.fireTableDataChanged();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    protected abstract Object computeInheritValue(StyleMetaData var1, int var2);

    protected abstract boolean defineFullValue(StyleMetaData var1, Object var2);

    protected Object computeFullValue(StyleMetaData metaData, int row) {
        T dataBackend1 = this.getDataBackend();
        Object[] fullValues = dataBackend1.getFullValues();
        Object o = fullValues[row];
        if (o == StyleDataBackend.NULL_INDICATOR) {
            return null;
        }
        if (o != null) {
            return o;
        }
        ResolverStyleSheet styleSheet = dataBackend1.getResolvedStyle();
        Object lastElement = styleSheet.getStyleProperty(metaData.getStyleKey());
        fullValues[row] = lastElement != null ? lastElement : StyleDataBackend.NULL_INDICATOR;
        return lastElement;
    }

    public Class getClassForCell(int rowIndex, int columnIndex) {
        StyleMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return GroupingHeader.class;
        }
        switch (columnIndex) {
            case 0: {
                return GroupedName.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return metaData.getTargetType();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public PropertyEditor getEditorForCell(int rowIndex, int columnIndex) {
        StyleMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 2: {
                return this.computeEditor(metaData, rowIndex);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    protected PropertyEditor computeEditor(StyleMetaData metaData, int row) {
        Object[] propertyEditors = this.getDataBackend().getPropertyEditors();
        Object o = propertyEditors[row];
        if (o == StyleDataBackend.NULL_INDICATOR) {
            return null;
        }
        if (o != null) {
            return (PropertyEditor)o;
        }
        PropertyEditor propertyEditor = metaData.getEditor();
        if (propertyEditor == null) {
            propertyEditor = this.getDefaultEditor(metaData.getTargetType());
        }
        propertyEditors[row] = propertyEditor == null ? StyleDataBackend.NULL_INDICATOR : propertyEditor;
        return propertyEditor;
    }

    protected PropertyEditor getDefaultEditor(Class type) {
        if (String.class.equals((Object)type)) {
            return null;
        }
        return FastPropertyEditorManager.findEditor(type);
    }

    @Override
    public String getValueRole(int row, int column) {
        return "Value";
    }

    @Override
    public String[] getExtraFields(int row, int column) {
        return EXTRA_FIELDS;
    }

    @Override
    public GroupingHeader getGroupHeader(int index) {
        return this.getGroupings(index);
    }

    @Override
    public boolean isHeaderRow(int index) {
        return this.dataBackend.getMetaData(index) == null;
    }

    protected static class NotifyChangeTask
    implements Runnable {
        private T dataBackend;
        final /* synthetic */ AbstractStyleTableModel this$0;

        protected NotifyChangeTask(T dataBackend) {
            this.this$0 = var1_1;
            this.dataBackend = dataBackend;
        }

        @Override
        public void run() {
            this.this$0.setDataBackend(this.dataBackend);
            this.this$0.fireTableDataChanged();
        }
    }

    protected class SameElementsUpdateDataTask
    implements Runnable {
        private T dataBackend;
        private boolean synchronous;
        final /* synthetic */ AbstractStyleTableModel this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        protected SameElementsUpdateDataTask(T elements, boolean synchronous) {
            this.this$0 = (AbstractStyleTableModel)n;
            this.dataBackend = elements;
            this.synchronous = synchronous;
        }

        @Override
        public void run() {
            this.dataBackend.resetCache();
            try {
                if (this.synchronous || SwingUtilities.isEventDispatchThread()) {
                    this.this$0.setDataBackend(this.dataBackend);
                    this.this$0.fireTableDataChanged();
                } else {
                    SwingUtilities.invokeAndWait(new NotifyChangeTask(this.this$0, this.dataBackend));
                }
            }
            catch (Exception e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }
    }
}

