/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.styles;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.styles.StyleTableModel;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.SidePanel;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTable;
import org.pentaho.reporting.designer.core.util.table.GroupedMetaTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupedNameCellRenderer;
import org.pentaho.reporting.designer.core.util.table.SortHeaderPanel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.libraries.designtime.swing.DefaultTableHeaderRenderer;

public class StyleEditorPanel
extends SidePanel {
    protected static final Element[] EMPTY_DATA = new Element[0];
    private StyleTableModel dataModel;
    private ElementMetaDataTable table;
    private ReportModelChangeHandler changeHandler;
    private AbstractReportDefinition report;
    private SortHeaderPanel headerPanel;

    public StyleEditorPanel() {
        this.setLayout(new BorderLayout());
        this.dataModel = this.createDataModel();
        this.table = new ElementMetaDataTable();
        this.table.setModel(new GroupedMetaTableModel(this.dataModel));
        this.table.getColumnModel().getColumn(0).setCellRenderer(new GroupedNameCellRenderer());
        this.applyHeaderSize(this.table.getColumnModel().getColumn(1));
        this.applyHeaderSize(this.table.getColumnModel().getColumn(3));
        this.changeHandler = new ReportModelChangeHandler();
        this.headerPanel = new SortHeaderPanel(this.dataModel);
        this.add((Component)this.headerPanel, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    protected StyleTableModel createDataModel() {
        return new StyleTableModel();
    }

    private void applyHeaderSize(TableColumn col) {
        col.setHeaderRenderer((TableCellRenderer)new DefaultTableHeaderRenderer());
        col.sizeWidthToFit();
    }

    @Override
    protected void updateSelection(DocumentContextSelectionModel model) {
        List<Element> selectedElementsOfType = model.getSelectedElementsOfType(Element.class);
        Element[] visualElements = selectedElementsOfType.toArray(new Element[selectedElementsOfType.size()]);
        this.setData(visualElements);
    }

    public Element[] getData() {
        return this.dataModel.getData();
    }

    protected void refreshData() {
        this.dataModel.setData(this.dataModel.getData());
    }

    public void setData(Element[] elements) {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        this.dataModel.setData(elements);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
        this.headerPanel.setEnabled(enabled);
    }

    @Override
    protected void updateActiveContext(ReportDocumentContext oldContext, ReportDocumentContext newContext) {
        this.table.stopEditing();
        super.updateActiveContext(oldContext, newContext);
        if (this.report != null) {
            this.report.removeReportModelListener((ReportModelListener)this.changeHandler);
        }
        if (newContext == null) {
            this.report = null;
            this.dataModel.setReportRenderContext(null);
            this.setData(EMPTY_DATA);
        } else {
            this.report = newContext.getReportDefinition();
            this.report.addReportModelListener((ReportModelListener)this.changeHandler);
            this.dataModel.setReportRenderContext(newContext);
        }
    }

    @Override
    protected void updateDesignerContext(ReportDesignerContext oldContext, ReportDesignerContext newContext) {
        super.updateDesignerContext(oldContext, newContext);
        this.table.setReportDesignerContext(newContext);
    }

    protected StyleTableModel getDataModel() {
        return this.dataModel;
    }

    private class ReportModelChangeHandler
    implements ReportModelListener {
        private ReportModelChangeHandler() {
        }

        public void nodeChanged(ReportModelEvent event) {
            if (!(event.getElement() instanceof Element)) {
                return;
            }
            Object element = event.getElement();
            Element[] data = StyleEditorPanel.this.getData();
            for (int i = 0; i < data.length; ++i) {
                Element reportElement = data[i];
                if (element != reportElement) continue;
                StyleEditorPanel.this.refreshData();
                return;
            }
        }
    }
}

