/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.pentaho.reporting.designer.core.settings.ExternalToolSettings;
import org.pentaho.reporting.designer.core.settings.SettingsMessages;
import org.pentaho.reporting.designer.core.settings.ui.SettingsPlugin;
import org.pentaho.reporting.designer.core.settings.ui.ToolSettingsPanel;
import org.pentaho.reporting.designer.core.settings.ui.ValidationResult;
import org.pentaho.reporting.designer.core.util.IconLoader;

public class ExternalToolSettingsPanel
extends JPanel
implements SettingsPlugin {
    private ToolSettingsPanel toolSettingsPanelPDF;
    private ToolSettingsPanel toolSettingsPanelRTF;
    private ToolSettingsPanel toolSettingsPanelXLS;
    private ToolSettingsPanel toolSettingsPanelCSV;

    public ExternalToolSettingsPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.toolSettingsPanelPDF = new ToolSettingsPanel();
        this.toolSettingsPanelRTF = new ToolSettingsPanel();
        this.toolSettingsPanelXLS = new ToolSettingsPanel();
        this.toolSettingsPanelCSV = new ToolSettingsPanel();
        tabbedPane.addTab(SettingsMessages.getInstance().getString("ExternalToolSettingsPanel.Tab.PDF"), this.toolSettingsPanelPDF);
        tabbedPane.addTab(SettingsMessages.getInstance().getString("ExternalToolSettingsPanel.Tab.RTF"), this.toolSettingsPanelRTF);
        tabbedPane.addTab(SettingsMessages.getInstance().getString("ExternalToolSettingsPanel.Tab.XLS"), this.toolSettingsPanelXLS);
        tabbedPane.addTab(SettingsMessages.getInstance().getString("ExternalToolSettingsPanel.Tab.CSV"), this.toolSettingsPanelCSV);
        this.setLayout(new BorderLayout());
        this.add((Component)tabbedPane, "Center");
        this.reset();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getExternalToolsIcon32();
    }

    @Override
    public String getTitle() {
        return SettingsMessages.getInstance().getString("SettingsDialog.ExternalTool");
    }

    @Override
    public ValidationResult validate(ValidationResult validationResult) {
        this.toolSettingsPanelPDF.validate(validationResult);
        this.toolSettingsPanelRTF.validate(validationResult);
        this.toolSettingsPanelXLS.validate(validationResult);
        this.toolSettingsPanelCSV.validate(validationResult);
        return validationResult;
    }

    @Override
    public void apply() {
        ExternalToolSettings.getInstance().setUseDefaultPDFViewer(this.toolSettingsPanelPDF.isUseDefaultApplication());
        ExternalToolSettings.getInstance().setCustomPDFViewerExecutable(this.toolSettingsPanelPDF.getCustomExecutable());
        ExternalToolSettings.getInstance().setCustomPDFViewerParameters(this.toolSettingsPanelPDF.getCustomExecutableParameters());
        ExternalToolSettings.getInstance().setUseDefaultRTFViewer(this.toolSettingsPanelRTF.isUseDefaultApplication());
        ExternalToolSettings.getInstance().setCustomRTFViewerExecutable(this.toolSettingsPanelRTF.getCustomExecutable());
        ExternalToolSettings.getInstance().setCustomRTFViewerParameters(this.toolSettingsPanelRTF.getCustomExecutableParameters());
        ExternalToolSettings.getInstance().setUseDefaultXLSViewer(this.toolSettingsPanelXLS.isUseDefaultApplication());
        ExternalToolSettings.getInstance().setCustomXLSViewerExecutable(this.toolSettingsPanelXLS.getCustomExecutable());
        ExternalToolSettings.getInstance().setCustomXLSViewerParameters(this.toolSettingsPanelXLS.getCustomExecutableParameters());
        ExternalToolSettings.getInstance().setUseDefaultCSVViewer(this.toolSettingsPanelCSV.isUseDefaultApplication());
        ExternalToolSettings.getInstance().setCustomCSVViewerExecutable(this.toolSettingsPanelCSV.getCustomExecutable());
        ExternalToolSettings.getInstance().setCustomCSVViewerParameters(this.toolSettingsPanelCSV.getCustomExecutableParameters());
    }

    @Override
    public void reset() {
        this.toolSettingsPanelPDF.setUseDefaultApplication(ExternalToolSettings.getInstance().isUseDefaultPDFViewer());
        this.toolSettingsPanelPDF.setCustomExecutable(ExternalToolSettings.getInstance().getCustomPDFViewerExecutable());
        this.toolSettingsPanelPDF.setCustomExecutableParameters(ExternalToolSettings.getInstance().getCustomPDFViewerParameters());
        this.toolSettingsPanelRTF.setUseDefaultApplication(ExternalToolSettings.getInstance().isUseDefaultRTFViewer());
        this.toolSettingsPanelRTF.setCustomExecutable(ExternalToolSettings.getInstance().getCustomRTFViewerExecutable());
        this.toolSettingsPanelRTF.setCustomExecutableParameters(ExternalToolSettings.getInstance().getCustomRTFViewerParameters());
        this.toolSettingsPanelXLS.setUseDefaultApplication(ExternalToolSettings.getInstance().isUseDefaultXLSViewer());
        this.toolSettingsPanelXLS.setCustomExecutable(ExternalToolSettings.getInstance().getCustomXLSViewerExecutable());
        this.toolSettingsPanelXLS.setCustomExecutableParameters(ExternalToolSettings.getInstance().getCustomXLSViewerParameters());
        this.toolSettingsPanelCSV.setUseDefaultApplication(ExternalToolSettings.getInstance().isUseDefaultCSVViewer());
        this.toolSettingsPanelCSV.setCustomExecutable(ExternalToolSettings.getInstance().getCustomCSVViewerExecutable());
        this.toolSettingsPanelCSV.setCustomExecutableParameters(ExternalToolSettings.getInstance().getCustomCSVViewerParameters());
    }
}

