/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang.ObjectUtils;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.FormulaEditorDialog;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.DataSchemaFieldDefinition;
import org.pentaho.reporting.designer.core.util.FormulaEditorDataModel;
import org.pentaho.reporting.designer.core.util.GUIUtils;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.GenericExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultProcessingContext;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.EllipsisButton;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class FormulaEditorPanel
extends JPanel {
    private static final FieldDefinition[] EMPTY_FIELDS = new FieldDefinition[0];
    private DefaultDataAttributeContext dataAttributeContext;
    private ReportDesignerContext reportDesignerContext;
    private boolean formulaFragment;
    private EllipsisButton ellipsisButton;
    private EventListenerList listenerList = new EventListenerList();
    private JTextField formulaField;
    private JComboBox formulaBox;
    private DefaultComboBoxModel tagModel;
    private boolean comboBoxActive;
    private boolean limitFields;
    private ValueChangeEventGenerator changeEventGenerator;
    private FormulaEditorDataModel editorDataModel;

    public FormulaEditorPanel() {
        this.dataAttributeContext = new DefaultDataAttributeContext();
        this.setLayout(new BorderLayout());
        this.ellipsisButton = new EllipsisButton("...");
        this.ellipsisButton.setDefaultCapable(false);
        this.ellipsisButton.setMargin(new Insets(0, 0, 0, 0));
        this.ellipsisButton.addActionListener((ActionListener)new OpenFormulaEditorAction());
        this.changeEventGenerator = new ValueChangeEventGenerator();
        this.tagModel = new DefaultComboBoxModel();
        this.tagModel.addListDataListener(this.changeEventGenerator);
        this.formulaBox = new JComboBox(this.tagModel);
        this.formulaBox.setEditable(true);
        this.formulaBox.addKeyListener(new KeyEventForwarder());
        this.formulaField = new JTextField();
        this.formulaField.getDocument().addDocumentListener((DocumentListener)((Object)this.changeEventGenerator));
        this.formulaBox.addKeyListener(new KeyEventForwarder());
        this.add((Component)this.formulaField, "Center");
        this.add((Component)this.ellipsisButton, "East");
    }

    private void activateComboBox() {
        if (this.comboBoxActive) {
            return;
        }
        String formula = this.getFormula();
        this.remove(this.formulaField);
        this.add((Component)this.formulaBox, "Center");
        this.formulaBox.setSelectedItem(formula);
        this.comboBoxActive = true;
        this.revalidate();
    }

    private void activateTextField() {
        if (!this.comboBoxActive) {
            return;
        }
        String formula = this.getFormula();
        this.remove(this.formulaBox);
        this.add((Component)this.formulaField, "Center");
        this.formulaField.setText(formula);
        this.comboBoxActive = false;
        this.revalidate();
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        this.reportDesignerContext = reportDesignerContext;
    }

    protected FieldDefinition[] computeFields() {
        if (this.reportDesignerContext == null) {
            return EMPTY_FIELDS;
        }
        ReportDocumentContext renderContext = this.reportDesignerContext.getActiveContext();
        if (renderContext == null) {
            return EMPTY_FIELDS;
        }
        ContextAwareDataSchemaModel model = renderContext.getReportDataSchemaModel();
        String[] columnNames = model.getColumnNames();
        ArrayList<Object> fields = new ArrayList<Object>(columnNames.length);
        DataSchema dataSchema = model.getDataSchema();
        DefaultDataAttributeContext attributeContext = new DefaultDataAttributeContext();
        String parameter = this.editorDataModel != null ? this.editorDataModel.getParameter() : null;
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            DataAttributes attributes = dataSchema.getAttributes(columnName);
            if (attributes == null) {
                throw new IllegalStateException("No data-schema for expression with name '" + columnName + '\'');
            }
            Object source = attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "source", String.class, (DataAttributeContext)attributeContext);
            if (this.limitFields && !"parameter".equals(source) && !"environment".equals(source) || this.limitFields && "report.date".equals(columnName)) continue;
            fields.add(new DataSchemaFieldDefinition(columnName, attributes, (DataAttributeContext)this.dataAttributeContext));
            if (ObjectUtils.equals((Object)parameter, (Object)columnName)) break;
        }
        if (this.editorDataModel != null) {
            String[] dataFields;
            for (String field : dataFields = this.editorDataModel.getDataFields()) {
                fields.add(new GenericDataFieldDefinition(field));
            }
        }
        return fields.toArray(new FieldDefinition[fields.size()]);
    }

    public boolean isLimitFields() {
        return this.limitFields;
    }

    public void setLimitFields(boolean limitFields) {
        this.limitFields = limitFields;
    }

    public boolean isFormulaFragment() {
        return this.formulaFragment;
    }

    public void setFormulaFragment(boolean formulaFragment) {
        this.formulaFragment = formulaFragment;
    }

    public String getFormula() {
        String s = this.comboBoxActive ? (String)this.formulaBox.getSelectedItem() : this.formulaField.getText();
        if (StringUtils.isEmpty((String)s, (boolean)true)) {
            return null;
        }
        if (this.isFormulaFragment()) {
            return FormulaUtil.createFormulaFromUIText((String)s);
        }
        return s;
    }

    public void setFormula(String text) {
        if (text == null) {
            this.formulaField.setText(null);
            this.formulaBox.setSelectedItem(null);
            return;
        }
        if (this.isFormulaFragment()) {
            GenericExpressionRuntime expressionRuntime = new GenericExpressionRuntime((DataRow)new StaticDataRow(), (TableModel)new DefaultTableModel(), -1, (ProcessingContext)new DefaultProcessingContext());
            String formulaText = FormulaUtil.createEditorTextFromFormula((String)text, (FormulaContext)new ReportFormulaContext((FormulaContext)new DefaultFormulaContext(), (ExpressionRuntime)expressionRuntime));
            this.formulaField.setText(formulaText);
            this.formulaBox.setSelectedItem(formulaText);
        } else {
            this.formulaField.setText(text);
            this.formulaBox.setSelectedItem(text);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.formulaField.setEnabled(enabled);
        this.ellipsisButton.setEnabled(enabled);
    }

    public void selectAll() {
        this.formulaField.selectAll();
    }

    public void setEditable(boolean editable) {
        this.formulaField.setEditable(editable);
        this.ellipsisButton.setEnabled(editable);
    }

    public boolean isEditable() {
        return this.formulaField.isEditable();
    }

    public void addFormulaKeyListener(KeyListener k) {
        this.listenerList.add(KeyListener.class, k);
    }

    public void removeFormulaKeyListener(KeyListener k) {
        this.listenerList.remove(KeyListener.class, k);
    }

    public String[] getTags() {
        int size = this.tagModel.getSize();
        String[] retval = new String[size];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (String)this.tagModel.getElementAt(i);
        }
        return retval;
    }

    public void setTags(String[] tags) {
        if (tags == null) {
            throw new NullPointerException();
        }
        this.tagModel.removeAllElements();
        for (int i = 0; i < tags.length; ++i) {
            this.tagModel.addElement(tags[i]);
        }
        if (tags.length == 0) {
            this.activateTextField();
        } else {
            this.activateComboBox();
        }
    }

    public FormulaEditorDataModel getEditorDataModel() {
        return this.editorDataModel;
    }

    public void setEditorDataModel(FormulaEditorDataModel editorDataModel) {
        this.editorDataModel = editorDataModel;
    }

    private static class GenericDataFieldDefinition
    implements FieldDefinition {
        private String name;

        private GenericDataFieldDefinition(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.name;
        }

        public Icon getIcon() {
            return IconLoader.getInstance().getDataSetsIcon();
        }

        public Class getFieldType() {
            return Object.class;
        }
    }

    private class ValueChangeEventGenerator
    extends DocumentChangeHandler
    implements ListDataListener,
    Runnable {
        private String lastValue;

        private ValueChangeEventGenerator() {
        }

        protected void handleChange(DocumentEvent e) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.run();
        }

        @Override
        public void run() {
            String formula = FormulaEditorPanel.this.getFormula();
            if (ObjectUtilities.equal((Object)this.lastValue, (Object)formula)) {
                return;
            }
            String oldValue = this.lastValue;
            this.lastValue = formula;
            FormulaEditorPanel.this.firePropertyChange("formula", oldValue, this.lastValue);
        }
    }

    private class KeyEventForwarder
    implements KeyListener {
        private KeyEventForwarder() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            KeyListener[] keyListeners = (KeyListener[])FormulaEditorPanel.this.listenerList.getListeners(KeyListener.class);
            for (int i = 0; i < keyListeners.length; ++i) {
                KeyListener keyListener = keyListeners[i];
                keyListener.keyTyped(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            KeyListener[] keyListeners = (KeyListener[])FormulaEditorPanel.this.listenerList.getListeners(KeyListener.class);
            for (int i = 0; i < keyListeners.length; ++i) {
                KeyListener keyListener = keyListeners[i];
                keyListener.keyPressed(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            KeyListener[] keyListeners = (KeyListener[])FormulaEditorPanel.this.listenerList.getListeners(KeyListener.class);
            for (int i = 0; i < keyListeners.length; ++i) {
                KeyListener keyListener = keyListeners[i];
                keyListener.keyReleased(e);
            }
        }
    }

    private class OpenFormulaEditorAction
    extends AbstractAction {
        private OpenFormulaEditorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormulaEditorDialog dialog = GUIUtils.createFormulaEditorDialog(FormulaEditorPanel.this.getReportDesignerContext(), FormulaEditorPanel.this);
            String formula = dialog.editFormula(FormulaEditorPanel.this.formulaField.getText(), FormulaEditorPanel.this.computeFields());
            if (formula == null) {
                return;
            }
            FormulaEditorPanel.this.formulaField.setText(formula);
        }
    }
}

