/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class FormulaFragmentCellRenderer
implements TableCellRenderer,
ListCellRenderer {
    private DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
    private DefaultListCellRenderer listCellRenderer;

    public FormulaFragmentCellRenderer() {
        this.tableCellRenderer.putClientProperty("html.disable", Boolean.TRUE);
        this.listCellRenderer = new DefaultListCellRenderer();
        this.listCellRenderer.putClientProperty("html.disable", Boolean.TRUE);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        String sValue = String.valueOf(value);
        if (StringUtils.isEmpty((String)sValue)) {
            return this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (sValue.startsWith("=")) {
            sValue = sValue.substring(1);
            table.setValueAt(sValue, row, column);
        }
        Component retval = this.tableCellRenderer.getTableCellRendererComponent(table, FormulaUtil.createCellUITextFromFormula((String)sValue), isSelected, hasFocus, row, column);
        if (!FormulaUtil.isValidFormulaFragment((String)sValue)) {
            retval.setBackground(Color.RED);
        } else if (retval.getBackground() == Color.RED) {
            retval.setBackground(table.getBackground());
        }
        return retval;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return this.listCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
        String sValue = String.valueOf(value);
        if (StringUtils.isEmpty((String)sValue)) {
            return this.listCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
        Component retval = this.listCellRenderer.getListCellRendererComponent((JList<?>)list, FormulaUtil.createCellUITextFromFormula((String)sValue), index, isSelected, cellHasFocus);
        if (!FormulaUtil.isValidFormulaFragment((String)sValue)) {
            retval.setBackground(Color.RED);
        } else {
            retval.setBackground(list.getBackground());
        }
        return retval;
    }
}

