/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class EditGroupUndoEntry
implements UndoEntry {
    private InstanceID group;
    private String oldName;
    private String newName;
    private String[] oldFields;
    private String[] newFields;

    public EditGroupUndoEntry(InstanceID group, String oldName, String newName, String[] oldFields, String[] newFields) {
        this.group = group;
        this.oldName = oldName;
        this.newName = newName;
        this.oldFields = (String[])oldFields.clone();
        this.newFields = (String[])newFields.clone();
    }

    public String getNewName() {
        return this.newName;
    }

    public String[] getNewFields() {
        return (String[])this.newFields.clone();
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        RelationalGroup elementById = (RelationalGroup)ModelUtility.findElementById(renderContext.getReportDefinition(), this.group);
        elementById.setName(this.oldName);
        elementById.setFieldsArray(this.oldFields);
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        RelationalGroup elementById = (RelationalGroup)ModelUtility.findElementById(renderContext.getReportDefinition(), this.group);
        elementById.setName(this.newName);
        elementById.setFieldsArray(this.newFields);
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        return null;
    }
}

