/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.welcome;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeModel;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractDesignerContextAction;
import org.pentaho.reporting.designer.core.actions.global.NewReportAction;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.HyperLink;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.welcome.FilesTree;
import org.pentaho.reporting.designer.core.welcome.ImagePanel;
import org.pentaho.reporting.designer.core.welcome.SamplesTreeBuilder;
import org.pentaho.reporting.designer.core.widgets.HyperlinkHandler;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;

public class WelcomePane
extends JDialog {
    private JCheckBox showOnStartupCheckbox;
    private ReportDesignerContext reportDesignerContext;
    private NewReportAction newReportAction;
    private CloseActionListener closeActionListener;
    private Image backgroundImage;

    public WelcomePane(JFrame frame, ReportDesignerContext reportDesignerContext) {
        super(frame);
        this.init(reportDesignerContext);
    }

    public WelcomePane(JDialog dialog, ReportDesignerContext reportDesignerContext) {
        super(dialog);
        this.init(reportDesignerContext);
    }

    public WelcomePane(ReportDesignerContext reportDesignerContext) {
        this.init(reportDesignerContext);
    }

    private void init(ReportDesignerContext reportDesignerContext) {
        if (reportDesignerContext == null) {
            throw new NullPointerException();
        }
        this.setTitle(Messages.getString("WelcomePane.title", new Object[0]));
        this.reportDesignerContext = reportDesignerContext;
        this.newReportAction = new NewReportAction();
        this.newReportAction.setReportDesignerContext(reportDesignerContext);
        this.closeActionListener = new CloseActionListener();
        this.showOnStartupCheckbox = new JCheckBox(Messages.getString("WelcomePane.showAtStartup", new Object[0]), WorkspaceSettings.getInstance().isShowLauncher());
        this.showOnStartupCheckbox.addActionListener(new TriggerShowWelcomePaneAction());
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(IconLoader.class.getResource("/org/pentaho/reporting/designer/core/icons/WelcomeBackground.png"));
        WaitingImageObserver obs = new WaitingImageObserver(this.backgroundImage);
        obs.waitImageLoaded();
        this.setResizable(false);
        this.initGUI();
        this.pack();
        JComponent contentPane = (JComponent)this.getContentPane();
        InputMap inputMap = contentPane.getInputMap();
        ActionMap actionMap = contentPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        actionMap.put("cancel", new CloseActionListener());
    }

    protected ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    private void initGUI() {
        JPanel buttonPane = this.createButtonsPane();
        JPanel sidePane = this.createSidePane();
        ImagePanel contentPane = new ImagePanel(this.backgroundImage, false, false);
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)sidePane, "Center");
        contentPane.add((Component)buttonPane, "West");
        this.setContentPane(contentPane);
    }

    private JPanel createSidePane() {
        int buttonPaneWidth = this.backgroundImage.getWidth(null);
        int buttonPaneHeight = this.backgroundImage.getHeight(null);
        TreeModel sampleTreeModel = SamplesTreeBuilder.getSampleTreeModel();
        FilesTree tree = new FilesTree(sampleTreeModel, this.reportDesignerContext, this);
        JScrollPane scrollPane = new JScrollPane(tree);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.getViewport().setBackground(Color.white);
        scrollPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JPanel sidePane = new JPanel();
        sidePane.setOpaque(false);
        sidePane.setBackground(new Color(0, 0, 0, 0));
        sidePane.setBorder(new EmptyBorder(0, 0, 0, 0));
        sidePane.setLayout(new GridBagLayout());
        sidePane.setBorder(new EmptyBorder(5, 5, 5, 5));
        sidePane.setMinimumSize(new Dimension(buttonPaneWidth - 514, buttonPaneHeight));
        sidePane.setPreferredSize(new Dimension(buttonPaneWidth - 514, buttonPaneHeight));
        sidePane.setMaximumSize(new Dimension(buttonPaneWidth - 514, buttonPaneHeight));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        sidePane.add((Component)new JLabel(Messages.getString("WelcomePane.samples", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        sidePane.add((Component)scrollPane, gbc);
        JPanel onlineResourcesList = new JPanel(new GridLayout(4, 1));
        onlineResourcesList.setOpaque(false);
        onlineResourcesList.setBackground(new Color(0, 0, 0, 0));
        onlineResourcesList.setBorder(new EmptyBorder(0, 0, 0, 0));
        onlineResourcesList.add(new JLabel(Messages.getString("WelcomePane.resources", new Object[0])));
        onlineResourcesList.add(this.createLink(Messages.getString("WelcomePane.forums", new Object[0]), Messages.getString("WelcomePane.url.forums", new Object[0])));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(20, 0, 20, 0);
        gbc.fill = 2;
        sidePane.add((Component)onlineResourcesList, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        sidePane.add((Component)this.showOnStartupCheckbox, gbc);
        return sidePane;
    }

    private JPanel createButtonsPane() {
        int buttonPaneHeight = this.backgroundImage.getHeight(null);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(null);
        buttonPane.setOpaque(false);
        buttonPane.setBackground(new Color(0, 0, 0, 0));
        buttonPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        buttonPane.setMinimumSize(new Dimension(514, buttonPaneHeight));
        buttonPane.setMaximumSize(new Dimension(514, buttonPaneHeight));
        buttonPane.setPreferredSize(new Dimension(514, buttonPaneHeight));
        try {
            Class<?> wizardClass = Class.forName("org.pentaho.reporting.designer.extensions.wizard.NewWizardReportAction");
            AbstractDesignerContextAction newWizardActionListener = (AbstractDesignerContextAction)wizardClass.newInstance();
            newWizardActionListener.setReportDesignerContext(this.reportDesignerContext);
            TransparentButton wizardBtn = new TransparentButton();
            wizardBtn.addActionListener(newWizardActionListener);
            wizardBtn.addActionListener(this.closeActionListener);
            wizardBtn.setBorderPainted(true);
            wizardBtn.setBounds(120, 147, 90, 118);
            buttonPane.add(wizardBtn);
            JLabel wizardLabel = new JLabel(newWizardActionListener.getValue("WIZARD.BUTTON.TEXT").toString(), 0);
            wizardLabel.setBounds(80, 273, 165, 56);
            buttonPane.add(wizardLabel);
            TransparentButton wizardLabelBtn = new TransparentButton();
            wizardLabelBtn.addActionListener(newWizardActionListener);
            wizardLabelBtn.addActionListener(this.closeActionListener);
            wizardLabelBtn.setBorderPainted(true);
            wizardLabelBtn.setBounds(80, 273, 165, 56);
            buttonPane.add(wizardLabelBtn);
        }
        catch (Exception e) {
            // empty catch block
        }
        TransparentButton newReportBtn = new TransparentButton();
        newReportBtn.addActionListener(this.newReportAction);
        newReportBtn.addActionListener(this.closeActionListener);
        newReportBtn.setBorderPainted(true);
        newReportBtn.setBounds(323, 147, 90, 118);
        buttonPane.add(newReportBtn);
        JLabel newReportLabel = new JLabel(Messages.getString("WelcomePane.newReportLabel", new Object[0]), 0);
        newReportLabel.setBounds(285, 273, 165, 56);
        buttonPane.add(newReportLabel);
        TransparentButton newReportLabelBtn = new TransparentButton();
        newReportLabelBtn.addActionListener(this.newReportAction);
        newReportLabelBtn.addActionListener(this.closeActionListener);
        newReportLabelBtn.setBorderPainted(true);
        newReportLabelBtn.setBounds(285, 273, 165, 56);
        buttonPane.add(newReportLabelBtn);
        return buttonPane;
    }

    public HyperLink createLink(String lbl, String link) {
        HyperLink linkLbl = new HyperLink(lbl);
        linkLbl.addMouseListener(new HyperlinkHandler(link, this));
        return linkLbl;
    }

    private class TransparentButton
    extends JButton {
        public TransparentButton() {
            this(null);
        }

        public TransparentButton(String text) {
            super(text);
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setComposite(AlphaComposite.getInstance(3, 0.05f));
            super.paint(g2);
            g2.dispose();
        }
    }

    public class CloseActionListener
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            WelcomePane.this.dispose();
        }
    }

    private class TriggerShowWelcomePaneAction
    implements ActionListener {
        private TriggerShowWelcomePaneAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            WorkspaceSettings.getInstance().setShowLauncher(WelcomePane.this.showOnStartupCheckbox.isSelected());
        }
    }
}

