/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.ResultGenerator;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;

@InterfaceAudience.Private
public class MultiRowResource
extends ResourceBase
implements Constants {
    private static final Log LOG = LogFactory.getLog(MultiRowResource.class);
    TableResource tableResource;
    Integer versions = null;

    public MultiRowResource(TableResource tableResource, String versions) throws IOException {
        this.tableResource = tableResource;
        if (versions != null) {
            this.versions = Integer.valueOf(versions);
        }
    }

    @GET
    @Produces(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        MultivaluedMap params = uriInfo.getQueryParameters();
        this.servlet.getMetrics().incrementRequests(1);
        try {
            CellSetModel model = new CellSetModel();
            for (String rk : (List)params.get((Object)"row")) {
                RowSpec rowSpec = new RowSpec(rk);
                if (this.versions != null) {
                    rowSpec.setMaxVersions(this.versions);
                }
                ResultGenerator generator = ResultGenerator.fromRowSpec(this.tableResource.getName(), rowSpec, null, !params.containsKey((Object)"nocache"));
                Cell value = null;
                RowModel rowModel = new RowModel(rk);
                if (generator.hasNext()) {
                    while ((value = (Cell)generator.next()) != null) {
                        rowModel.addCell(new CellModel(CellUtil.cloneFamily((Cell)value), CellUtil.cloneQualifier((Cell)value), value.getTimestamp(), CellUtil.cloneValue((Cell)value)));
                    }
                    model.addRow(rowModel);
                    continue;
                }
                LOG.trace((Object)("The row : " + rk + " not found in the table."));
            }
            if (model.getRows().size() == 0) {
                this.servlet.getMetrics().incrementFailedGetRequests(1);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"No rows found.\r\n").build();
            }
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return Response.ok((Object)model).build();
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return this.processException(e);
        }
    }
}

