/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.ScanDeleteTracker;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelServiceManager;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class VisibilityScanDeleteTracker
extends ScanDeleteTracker {
    private static final Log LOG = LogFactory.getLog(VisibilityScanDeleteTracker.class);
    private Map<Long, Pair<List<Tag>, Byte>> visibilityTagsDeleteFamily = new HashMap<Long, Pair<List<Tag>, Byte>>();
    private Map<Long, Pair<List<Tag>, Byte>> visibilityTagsDeleteFamilyVersion = new HashMap<Long, Pair<List<Tag>, Byte>>();
    private List<Pair<List<Tag>, Byte>> visibilityTagsDeleteColumns;
    private List<Pair<List<Tag>, Byte>> visiblityTagsDeleteColumnVersion = new ArrayList<Pair<List<Tag>, Byte>>();

    @Override
    public void add(Cell delCell) {
        long timestamp = delCell.getTimestamp();
        int qualifierOffset = delCell.getQualifierOffset();
        int qualifierLength = delCell.getQualifierLength();
        byte type = delCell.getTypeByte();
        if (type == KeyValue.Type.DeleteFamily.getCode()) {
            this.hasFamilyStamp = true;
            this.extractDeleteCellVisTags(delCell, KeyValue.Type.DeleteFamily);
            return;
        }
        if (type == KeyValue.Type.DeleteFamilyVersion.getCode()) {
            this.familyVersionStamps.add(timestamp);
            this.extractDeleteCellVisTags(delCell, KeyValue.Type.DeleteFamilyVersion);
            return;
        }
        if (this.deleteBuffer != null) {
            if (Bytes.compareTo((byte[])this.deleteBuffer, (int)this.deleteOffset, (int)this.deleteLength, (byte[])delCell.getQualifierArray(), (int)qualifierOffset, (int)qualifierLength) != 0) {
                this.visibilityTagsDeleteColumns = null;
                this.visiblityTagsDeleteColumnVersion = null;
            } else if (type == KeyValue.Type.Delete.getCode() && this.deleteTimestamp != timestamp) {
                this.visiblityTagsDeleteColumnVersion = null;
            }
        }
        this.deleteBuffer = delCell.getQualifierArray();
        this.deleteOffset = qualifierOffset;
        this.deleteLength = qualifierLength;
        this.deleteType = type;
        this.deleteTimestamp = timestamp;
        this.extractDeleteCellVisTags(delCell, KeyValue.Type.codeToType((byte)type));
    }

    private void extractDeleteCellVisTags(Cell delCell, KeyValue.Type type) {
        block20: {
            block19: {
                if (delCell.getTagsLengthUnsigned() <= 0) break block19;
                switch (type) {
                    case DeleteFamily: {
                        ArrayList<Tag> delTags = new ArrayList<Tag>();
                        if (this.visibilityTagsDeleteFamily != null) {
                            Byte deleteCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(delCell, delTags);
                            if (!delTags.isEmpty()) {
                                this.visibilityTagsDeleteFamily.put(delCell.getTimestamp(), (Pair<List<Tag>, Byte>)new Pair(delTags, (Object)deleteCellVisTagsFormat));
                                break;
                            }
                        }
                        break block20;
                    }
                    case DeleteFamilyVersion: {
                        ArrayList<Tag> delTags = new ArrayList<Tag>();
                        Byte deleteCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(delCell, delTags);
                        if (!delTags.isEmpty()) {
                            this.visibilityTagsDeleteFamilyVersion.put(delCell.getTimestamp(), (Pair<List<Tag>, Byte>)new Pair(delTags, (Object)deleteCellVisTagsFormat));
                            break;
                        }
                        break block20;
                    }
                    case DeleteColumn: {
                        if (this.visibilityTagsDeleteColumns == null) {
                            this.visibilityTagsDeleteColumns = new ArrayList<Pair<List<Tag>, Byte>>();
                        }
                        ArrayList<Tag> delTags = new ArrayList<Tag>();
                        Byte deleteCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(delCell, delTags);
                        if (!delTags.isEmpty()) {
                            this.visibilityTagsDeleteColumns.add((Pair<List<Tag>, Byte>)new Pair(delTags, (Object)deleteCellVisTagsFormat));
                            break;
                        }
                        break block20;
                    }
                    case Delete: {
                        if (this.visiblityTagsDeleteColumnVersion == null) {
                            this.visiblityTagsDeleteColumnVersion = new ArrayList<Pair<List<Tag>, Byte>>();
                        }
                        ArrayList<Tag> delTags = new ArrayList<Tag>();
                        Byte deleteCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(delCell, delTags);
                        if (!delTags.isEmpty()) {
                            this.visiblityTagsDeleteColumnVersion.add((Pair<List<Tag>, Byte>)new Pair(delTags, (Object)deleteCellVisTagsFormat));
                            break;
                        }
                        break block20;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid delete type");
                    }
                }
                break block20;
            }
            switch (type) {
                case DeleteFamily: {
                    this.visibilityTagsDeleteFamily = null;
                    break;
                }
                case DeleteFamilyVersion: {
                    this.visibilityTagsDeleteFamilyVersion = null;
                    break;
                }
                case DeleteColumn: {
                    this.visibilityTagsDeleteColumns = null;
                    break;
                }
                case Delete: {
                    this.visiblityTagsDeleteColumnVersion = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid delete type");
                }
            }
        }
    }

    @Override
    public DeleteTracker.DeleteResult isDeleted(Cell cell) {
        block25: {
            long timestamp = cell.getTimestamp();
            int qualifierOffset = cell.getQualifierOffset();
            int qualifierLength = cell.getQualifierLength();
            try {
                boolean matchFound;
                Byte putCellVisTagsFormat;
                if (this.hasFamilyStamp) {
                    if (this.visibilityTagsDeleteFamily != null) {
                        Set<Map.Entry<Long, Pair<List<Tag>, Byte>>> deleteFamilies = this.visibilityTagsDeleteFamily.entrySet();
                        for (Map.Entry<Long, Pair<List<Tag>, Byte>> entry : deleteFamilies) {
                            if (timestamp > entry.getKey()) continue;
                            ArrayList<Tag> putVisTags = new ArrayList<Tag>();
                            putCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(cell, putVisTags);
                            matchFound = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService().matchVisibility(putVisTags, putCellVisTagsFormat, (List)entry.getValue().getFirst(), (Byte)entry.getValue().getSecond());
                            if (!matchFound) continue;
                            return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
                        }
                    } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                        return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
                    }
                }
                if (this.familyVersionStamps.contains(timestamp)) {
                    if (this.visibilityTagsDeleteFamilyVersion != null) {
                        Pair<List<Tag>, Byte> tags = this.visibilityTagsDeleteFamilyVersion.get(timestamp);
                        if (tags != null) {
                            ArrayList<Tag> putVisTags = new ArrayList<Tag>();
                            Byte putCellVisTagsFormat2 = VisibilityUtils.extractVisibilityTags(cell, putVisTags);
                            boolean matchFound2 = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService().matchVisibility(putVisTags, putCellVisTagsFormat2, (List)tags.getFirst(), (Byte)tags.getSecond());
                            if (matchFound2) {
                                return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
                            }
                        }
                    } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                        return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
                    }
                }
                if (this.deleteBuffer == null) break block25;
                int ret = Bytes.compareTo((byte[])this.deleteBuffer, (int)this.deleteOffset, (int)this.deleteLength, (byte[])cell.getQualifierArray(), (int)qualifierOffset, (int)qualifierLength);
                if (ret == 0) {
                    if (this.deleteType == KeyValue.Type.DeleteColumn.getCode()) {
                        if (this.visibilityTagsDeleteColumns != null) {
                            for (Pair<List<Tag>, Byte> tags : this.visibilityTagsDeleteColumns) {
                                ArrayList<Tag> putVisTags = new ArrayList<Tag>();
                                putCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(cell, putVisTags);
                                matchFound = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService().matchVisibility(putVisTags, putCellVisTagsFormat, (List)tags.getFirst(), (Byte)tags.getSecond());
                                if (!matchFound) continue;
                                return DeleteTracker.DeleteResult.VERSION_DELETED;
                            }
                        } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                            return DeleteTracker.DeleteResult.VERSION_DELETED;
                        }
                    }
                    if (timestamp == this.deleteTimestamp) {
                        if (this.visiblityTagsDeleteColumnVersion != null) {
                            for (Pair<List<Tag>, Byte> tags : this.visiblityTagsDeleteColumnVersion) {
                                ArrayList<Tag> putVisTags = new ArrayList<Tag>();
                                putCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(cell, putVisTags);
                                matchFound = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService().matchVisibility(putVisTags, putCellVisTagsFormat, (List)tags.getFirst(), (Byte)tags.getSecond());
                                if (!matchFound) continue;
                                return DeleteTracker.DeleteResult.VERSION_DELETED;
                            }
                        } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                            return DeleteTracker.DeleteResult.VERSION_DELETED;
                        }
                    }
                    break block25;
                }
                if (ret < 0) {
                    this.deleteBuffer = null;
                    this.visibilityTagsDeleteColumns = null;
                    this.visiblityTagsDeleteColumnVersion = null;
                    break block25;
                }
                throw new IllegalStateException("isDeleted failed: deleteBuffer=" + Bytes.toStringBinary((byte[])this.deleteBuffer, (int)this.deleteOffset, (int)this.deleteLength) + ", qualifier=" + Bytes.toStringBinary((byte[])cell.getQualifierArray(), (int)qualifierOffset, (int)qualifierLength) + ", timestamp=" + timestamp + ", comparison result: " + ret);
            }
            catch (IOException e) {
                LOG.error((Object)"Error in isDeleted() check! Will treat cell as not deleted", (Throwable)e);
            }
        }
        return DeleteTracker.DeleteResult.NOT_DELETED;
    }

    @Override
    public void reset() {
        super.reset();
        this.visibilityTagsDeleteColumns = null;
        this.visibilityTagsDeleteFamily = new HashMap<Long, Pair<List<Tag>, Byte>>();
        this.visibilityTagsDeleteFamilyVersion = new HashMap<Long, Pair<List<Tag>, Byte>>();
        this.visiblityTagsDeleteColumnVersion = null;
    }
}

