/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.cda;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class CdaResponseParser
extends DefaultHandler {
    private static final Log logger = LogFactory.getLog(CdaResponseParser.class);
    private TypedTableModel model = new TypedTableModel();
    private ArrayList<String> columnRawData;
    private StringBuffer characterBuffer;
    private int rowNumber;
    private boolean nullValue;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);

    public CdaResponseParser() {
        this.model = new TypedTableModel();
    }

    public TypedTableModel getResult() {
        return this.model;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("ColumnMetaData".equals(qName)) {
            String type = attributes.getValue("type");
            String name = attributes.getValue("name");
            if (StringUtils.isEmpty((String)name)) {
                throw new ParseException("Column name is not given");
            }
            if (StringUtils.isEmpty((String)type)) {
                throw new ParseException("Column type is not given");
            }
            Class colType = "Numeric".equals(type) || "Integer".equals(type) ? Number.class : ("Date".equals(type) ? Date.class : String.class);
            this.model.addColumn(name, colType);
        } else if ("Row".equals(qName)) {
            this.columnRawData = new ArrayList();
        } else if ("Col".equals(qName)) {
            if ("true".equals(attributes.getValue("isNull"))) {
                this.nullValue = true;
                this.characterBuffer = null;
            } else {
                this.nullValue = false;
                this.characterBuffer = new StringBuffer();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if ("Row".equals(qName)) {
                int size = Math.min(this.columnRawData.size(), this.model.getColumnCount());
                for (int i = 0; i < size; ++i) {
                    String value = this.columnRawData.get(i);
                    if (value == null) {
                        this.model.setValueAt((Object)value, this.rowNumber, i);
                        continue;
                    }
                    Class columnClass = this.model.getColumnClass(i);
                    if (Date.class == columnClass) {
                        this.model.setValueAt((Object)this.format.parse(value), this.rowNumber, i);
                        continue;
                    }
                    if (Number.class == columnClass) {
                        this.model.setValueAt((Object)new BigDecimal(value), this.rowNumber, i);
                        continue;
                    }
                    this.model.setValueAt((Object)value, this.rowNumber, i);
                }
                ++this.rowNumber;
                this.columnRawData = null;
            } else if ("Col".equals(qName)) {
                if (this.nullValue) {
                    this.columnRawData.add(null);
                } else {
                    this.columnRawData.add(this.characterBuffer.toString());
                }
                this.nullValue = false;
                this.characterBuffer = null;
            }
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.characterBuffer != null) {
            this.characterBuffer.append(ch, start, length);
        }
    }

    public static TypedTableModel performParse(InputStream postResult) throws IOException, ReportDataFactoryException {
        try {
            CdaResponseParser contentHandler = new CdaResponseParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            try {
                reader.setFeature("http://xml.org/sax/features/xmlns-uris", false);
            }
            catch (SAXException e) {
                // empty catch block
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespaces", false);
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            }
            catch (SAXException e) {
                logger.warn((Object)"No Namespace features will be available. (Yes, this is serious)", (Throwable)e);
            }
            reader.setContentHandler(contentHandler);
            reader.parse(new InputSource(postResult));
            return contentHandler.getResult();
        }
        catch (ParserConfigurationException e) {
            throw new ReportDataFactoryException("Failed to init XML system", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ReportDataFactoryException("Failed to parse document", (Throwable)e);
        }
    }
}

