/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Binding;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.matcher.Matcher;
import org.elasticsearch.common.inject.name.Names;

public class Injectors {
    public static <T> T getInstance(Injector injector, Class<T> type, String name) {
        return injector.getInstance(Key.get(type, (Annotation)Names.named(name)));
    }

    public static <T> Set<T> getInstancesOf(Injector injector, Class<T> baseClass) {
        HashSet<T> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries) {
            Binding<?> binding;
            Object value;
            Key<?> key = entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !baseClass.isAssignableFrom(keyType) || (value = (binding = entry.getValue()).getProvider().get()) == null) continue;
            T castValue = baseClass.cast(value);
            answer.add(castValue);
        }
        return answer;
    }

    public static <T> Set<T> getInstancesOf(Injector injector, Matcher<Class> matcher) {
        HashSet<?> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries) {
            Key<?> key = entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !matcher.matches(keyType)) continue;
            Binding<?> binding = entry.getValue();
            Object value = binding.getProvider().get();
            answer.add(value);
        }
        return answer;
    }

    public static <T> Set<Provider<T>> getProvidersOf(Injector injector, Matcher<Class> matcher) {
        HashSet<Provider<T>> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries) {
            Key<?> key = entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !matcher.matches(keyType)) continue;
            Binding<?> binding = entry.getValue();
            answer.add(binding.getProvider());
        }
        return answer;
    }

    public static <T> Set<Provider<T>> getProvidersOf(Injector injector, Class<T> baseClass) {
        HashSet<Provider<T>> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries) {
            Key<?> key = entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !baseClass.isAssignableFrom(keyType)) continue;
            Binding<?> binding = entry.getValue();
            answer.add(binding.getProvider());
        }
        return answer;
    }

    public static boolean hasBinding(Injector injector, Matcher<Class> matcher) {
        return !Injectors.getBindingsOf(injector, matcher).isEmpty();
    }

    public static boolean hasBinding(Injector injector, Class<?> baseClass) {
        return !Injectors.getBindingsOf(injector, baseClass).isEmpty();
    }

    public static boolean hasBinding(Injector injector, Key<?> key) {
        Binding<?> binding = Injectors.getBinding(injector, key);
        return binding != null;
    }

    public static Binding<?> getBinding(Injector injector, Key<?> key) {
        Map<Key<?>, Binding<?>> bindings = injector.getBindings();
        Binding<?> binding = bindings.get(key);
        return binding;
    }

    public static Set<Binding<?>> getBindingsOf(Injector injector, Matcher<Class> matcher) {
        HashSet<Binding<?>> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries) {
            Key<?> key = entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !matcher.matches(keyType)) continue;
            answer.add(entry.getValue());
        }
        return answer;
    }

    public static Set<Binding<?>> getBindingsOf(Injector injector, Class<?> baseClass) {
        HashSet<Binding<?>> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries) {
            Key<?> key = entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !baseClass.isAssignableFrom(keyType)) continue;
            answer.add(entry.getValue());
        }
        return answer;
    }

    public static <T> Class<?> getKeyType(Key<?> key) {
        Class keyType = null;
        TypeLiteral<?> typeLiteral = key.getTypeLiteral();
        Type type = typeLiteral.getType();
        if (type instanceof Class) {
            keyType = (Class)type;
        }
        return keyType;
    }

    public static void close(Injector injector) {
    }

    public static void cleanCaches(Injector injector) {
        Field delegateField;
        Object cache;
        Field cacheField;
        try {
            Field stateField = injector.getClass().getDeclaredField("state");
            stateField.setAccessible(true);
            Object state = stateField.get(injector);
            if (state.getClass().getName().contains("InheritingState")) {
                Field blacklistedKeysField = state.getClass().getDeclaredField("blacklistedKeys");
                blacklistedKeysField.setAccessible(true);
                Object blacklistedKeys = blacklistedKeysField.get(state);
                Field backingSetField = blacklistedKeys.getClass().getDeclaredField("backingSet");
                backingSetField.setAccessible(true);
                ((Set)backingSetField.get(blacklistedKeys)).clear();
            }
        }
        catch (Exception e) {
            throw new ElasticSearchIllegalStateException("Failed to clear state from injector", e);
        }
        try {
            Field constructorsField = injector.getClass().getDeclaredField("constructors");
            constructorsField.setAccessible(true);
            Object constructors = constructorsField.get(injector);
            cacheField = constructors.getClass().getDeclaredField("cache");
            cacheField.setAccessible(true);
            cache = cacheField.get(constructors);
            delegateField = cache.getClass().getSuperclass().getDeclaredField("delegate");
            delegateField.setAccessible(true);
            ((Map)delegateField.get(cache)).clear();
        }
        catch (Exception e) {
            throw new ElasticSearchIllegalStateException("Failed to clear constructors cache from injector", e);
        }
        try {
            Field membersField = injector.getClass().getDeclaredField("membersInjectorStore");
            membersField.setAccessible(true);
            Object members = membersField.get(injector);
            if (members != null) {
                cacheField = members.getClass().getDeclaredField("cache");
                cacheField.setAccessible(true);
                cache = cacheField.get(members);
                delegateField = cache.getClass().getSuperclass().getDeclaredField("delegate");
                delegateField.setAccessible(true);
                ((Map)delegateField.get(cache)).clear();
            }
        }
        catch (Exception e) {
            throw new ElasticSearchIllegalStateException("Failed to clear constructors cache from injector", e);
        }
        if (injector.getParent() != null) {
            Injectors.cleanCaches(injector.getParent());
        }
    }
}

