/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.stream.StreamOutput;

public class BytesStreamOutput
extends StreamOutput
implements BytesStream {
    protected byte[] buf;
    protected int count;

    public BytesStreamOutput() {
        this(126);
    }

    public BytesStreamOutput(int size) {
        this.buf = new byte[size];
    }

    @Override
    public void writeByte(byte b) throws IOException {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = b;
        this.count = newcount;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int newcount = this.count + length;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(b, offset, this.buf, this.count, length);
        this.count = newcount;
    }

    public void seek(int seekTo) {
        this.count = seekTo;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public byte[] copiedByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    @Override
    public byte[] unsafeByteArray() {
        return this.buf;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int strlen = str.length();
        int utflen = 0;
        char c = '\u0000';
        for (int i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        int newcount = this.count + utflen + 4;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        byte[] bytearr = this.buf;
        bytearr[this.count++] = (byte)(utflen >> 24);
        bytearr[this.count++] = (byte)(utflen >> 16);
        bytearr[this.count++] = (byte)(utflen >> 8);
        bytearr[this.count++] = (byte)utflen;
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[this.count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[this.count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[this.count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[this.count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[this.count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
    }
}

