/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.versioned;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.common.lucene.versioned.VersionedMap;
import org.elasticsearch.common.trove.map.hash.TIntIntHashMap;
import org.elasticsearch.common.util.concurrent.ThreadSafe;

@ThreadSafe
public class NativeVersionedMap
implements VersionedMap {
    private final int segmentMask;
    private final int segmentShift;
    private final Segment[] segments;

    public NativeVersionedMap() {
        this(16);
    }

    public NativeVersionedMap(int concurrencyLevel) {
        int ssize;
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = new Segment[ssize];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean beforeVersion(int key, int versionToCheck) {
        Segment segment = this.segmentFor(NativeVersionedMap.hash(key));
        segment.rwl.readLock().lock();
        try {
            int result = segment.map.get(key);
            boolean bl = result == -1 || versionToCheck < result;
            return bl;
        }
        finally {
            segment.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putVersion(int key, int version) {
        Segment segment = this.segmentFor(NativeVersionedMap.hash(key));
        segment.rwl.writeLock().lock();
        try {
            segment.map.put(key, version);
        }
        finally {
            segment.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putVersionIfAbsent(int key, int version) {
        Segment segment = this.segmentFor(NativeVersionedMap.hash(key));
        segment.rwl.writeLock().lock();
        try {
            if (!segment.map.containsKey(key)) {
                segment.map.put(key, version);
            }
        }
        finally {
            segment.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        for (Segment segment : this.segments) {
            segment.rwl.writeLock().lock();
            try {
                segment.map.clear();
            }
            finally {
                segment.rwl.writeLock().unlock();
            }
        }
    }

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    private static class Segment {
        final ReadWriteLock rwl = new ReentrantReadWriteLock();
        final TIntIntHashMap map = new TIntIntHashMap(10, 0.5f, 0, -1);

        private Segment() {
        }
    }
}

