/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.path.PathTrie;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.support.RestUtils;

public class RestController
extends AbstractLifecycleComponent<RestController> {
    private final PathTrie<RestHandler> getHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> postHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> putHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> deleteHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> headHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> optionsHandlers = new PathTrie(RestUtils.REST_DECODER);

    @Inject
    public RestController(Settings settings) {
        super(settings);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
    }

    @Override
    protected void doStop() throws ElasticSearchException {
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    public void registerHandler(RestRequest.Method method, String path, RestHandler handler) {
        switch (method) {
            case GET: {
                this.getHandlers.insert(path, handler);
                break;
            }
            case DELETE: {
                this.deleteHandlers.insert(path, handler);
                break;
            }
            case POST: {
                this.postHandlers.insert(path, handler);
                break;
            }
            case PUT: {
                this.putHandlers.insert(path, handler);
                break;
            }
            case OPTIONS: {
                this.optionsHandlers.insert(path, handler);
                break;
            }
            case HEAD: {
                this.headHandlers.insert(path, handler);
                break;
            }
            default: {
                throw new ElasticSearchIllegalArgumentException("Can't handle [" + (Object)((Object)method) + "] for path [" + path + "]");
            }
        }
    }

    public boolean dispatchRequest(RestRequest request, RestChannel channel) {
        RestHandler handler = this.getHandler(request);
        if (handler == null) {
            return false;
        }
        try {
            handler.handleRequest(request, channel);
        }
        catch (Exception e) {
            try {
                channel.sendResponse(new XContentThrowableRestResponse(request, e));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response for uri [" + request.uri() + "]", e1, new Object[0]);
            }
        }
        return true;
    }

    private RestHandler getHandler(RestRequest request) {
        String path = this.getPath(request);
        RestRequest.Method method = request.method();
        if (method == RestRequest.Method.GET) {
            return this.getHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.POST) {
            return this.postHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.PUT) {
            return this.putHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.DELETE) {
            return this.deleteHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.HEAD) {
            return this.headHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.OPTIONS) {
            return this.optionsHandlers.retrieve(path, request.params());
        }
        return null;
    }

    private String getPath(RestRequest request) {
        return request.rawPath();
    }
}

