/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.ints;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.trove.iterator.TIntIntIterator;
import org.elasticsearch.common.trove.map.hash.TIntIntHashMap;
import org.elasticsearch.common.trove.set.hash.TIntHashSet;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.ints.IntFieldData;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.ints.InternalIntTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class TermsIntFacetCollector
extends AbstractFacetCollector {
    private final FieldDataCache fieldDataCache;
    private final String indexFieldName;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int numberOfShards;
    private final FieldDataType fieldDataType;
    private IntFieldData fieldData;
    private final StaticAggregatorValueProc aggregator;
    private final SearchScript script;

    public TermsIntFacetCollector(String facetName, String fieldName, int size, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<String> excluded, String scriptLang, String script, Map<String, Object> params) {
        super(facetName);
        this.fieldDataCache = context.fieldDataCache();
        this.size = size;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new ElasticSearchIllegalArgumentException("Field [" + fieldName + "] doesn't have a type, can't run terms int facet collector on it");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        if (smartMappers.mapper().fieldDataType() != FieldDataType.DefaultTypes.INT) {
            throw new ElasticSearchIllegalArgumentException("Field [" + fieldName + "] is not of int type, can't run terms int facet collector on it");
        }
        this.indexFieldName = smartMappers.mapper().names().indexName();
        this.fieldDataType = smartMappers.mapper().fieldDataType();
        this.script = script != null ? context.scriptService().search(context.lookup(), scriptLang, script, params) : null;
        this.aggregator = this.script == null && excluded.isEmpty() ? new StaticAggregatorValueProc(CacheRecycler.popIntIntMap()) : new AggregatorValueProc(CacheRecycler.popIntIntMap(), excluded, this.script);
        if (allTerms) {
            try {
                for (IndexReader reader : context.searcher().subReaders()) {
                    IntFieldData fieldData = (IntFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
                    fieldData.forEachValue(this.aggregator);
                }
            }
            catch (Exception e) {
                throw new FacetPhaseExecutionException(facetName, "failed to load all terms", e);
            }
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (this.script != null) {
            this.script.setScorer(scorer);
        }
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (IntFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
        if (this.script != null) {
            this.script.setNextReader(reader);
        }
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachValueInDoc(doc, this.aggregator);
    }

    @Override
    public Facet facet() {
        TIntIntHashMap facets = this.aggregator.facets();
        if (facets.isEmpty()) {
            CacheRecycler.pushIntIntMap(facets);
            return new InternalIntTermsFacet(this.facetName, this.comparatorType, this.size, ImmutableList.<InternalIntTermsFacet.IntEntry>of(), this.aggregator.missing());
        }
        if (this.size < 5000) {
            EntryPriorityQueue ordered = new EntryPriorityQueue(this.size, this.comparatorType.comparator());
            TIntIntIterator it = facets.iterator();
            while (it.hasNext()) {
                it.advance();
                ordered.insertWithOverflow(new InternalIntTermsFacet.IntEntry(it.key(), it.value()));
            }
            InternalIntTermsFacet.IntEntry[] list = new InternalIntTermsFacet.IntEntry[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (InternalIntTermsFacet.IntEntry)ordered.pop();
            }
            CacheRecycler.pushIntIntMap(facets);
            return new InternalIntTermsFacet(this.facetName, this.comparatorType, this.size, Arrays.asList(list), this.aggregator.missing());
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size);
        TIntIntIterator it = facets.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new InternalIntTermsFacet.IntEntry(it.key(), it.value()));
        }
        CacheRecycler.pushIntIntMap(facets);
        return new InternalIntTermsFacet(this.facetName, this.comparatorType, this.size, ordered, this.aggregator.missing());
    }

    public static class StaticAggregatorValueProc
    implements IntFieldData.ValueInDocProc,
    IntFieldData.ValueProc {
        private final TIntIntHashMap facets;
        private int missing;

        public StaticAggregatorValueProc(TIntIntHashMap facets) {
            this.facets = facets;
        }

        @Override
        public void onValue(int value) {
            this.facets.putIfAbsent(value, 0);
        }

        @Override
        public void onValue(int docId, int value) {
            this.facets.adjustOrPutValue(value, 1, 1);
        }

        @Override
        public void onMissing(int docId) {
            ++this.missing;
        }

        public final TIntIntHashMap facets() {
            return this.facets;
        }

        public final int missing() {
            return this.missing;
        }
    }

    public static class AggregatorValueProc
    extends StaticAggregatorValueProc {
        private final SearchScript script;
        private final TIntHashSet excluded;

        public AggregatorValueProc(TIntIntHashMap facets, Set<String> excluded, SearchScript script) {
            super(facets);
            if (excluded == null || excluded.isEmpty()) {
                this.excluded = null;
            } else {
                this.excluded = new TIntHashSet(excluded.size());
                for (String s : excluded) {
                    this.excluded.add(Integer.parseInt(s));
                }
            }
            this.script = script;
        }

        @Override
        public void onValue(int docId, int value) {
            if (this.excluded != null && this.excluded.contains(value)) {
                return;
            }
            if (this.script != null) {
                this.script.setNextDocId(docId);
                this.script.setNextVar("term", value);
                Object scriptValue = this.script.run();
                if (scriptValue == null) {
                    return;
                }
                if (scriptValue instanceof Boolean) {
                    if (!((Boolean)scriptValue).booleanValue()) {
                        return;
                    }
                } else {
                    value = ((Number)scriptValue).intValue();
                }
            }
            super.onValue(docId, value);
        }
    }
}

