/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs;

import java.util.Map;
import java.util.TreeMap;

public class UserAuthenticationData {
    public static final Type USERNAME = new Type("username");
    public static final Type PASSWORD = new Type("password");
    public static final Type DOMAIN = new Type("domain");
    private Map authenticationData = new TreeMap();

    public void setData(Type type, char[] cArray) {
        this.authenticationData.put(type, cArray);
    }

    public char[] getData(Type type) {
        return (char[])this.authenticationData.get(type);
    }

    public void cleanup() {
        for (char[] cArray : this.authenticationData.values()) {
            if (cArray == null || cArray.length < 0) continue;
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = '\u0000';
            }
        }
        this.authenticationData.clear();
    }

    public static class Type
    implements Comparable {
        private final String type;

        public Type(String string) {
            this.type = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Type type = (Type)object;
            return !(this.type != null ? !this.type.equals(type.type) : type.type != null);
        }

        public int compareTo(Object object) {
            Type type = (Type)object;
            return this.type.compareTo(type.type);
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }

        public String toString() {
            return this.type;
        }
    }
}

