/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.tasks;

import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.tasks.AbstractSyncTask;

public class CopyTask
extends AbstractSyncTask {
    private boolean overwrite = false;
    private boolean preserveLastModified = true;

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public void setPreserveLastModified(boolean bl) {
        this.preserveLastModified = bl;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isPreserveLastModified() {
        return this.preserveLastModified;
    }

    protected void handleOutOfDateFile(FileObject fileObject, FileObject fileObject2) throws FileSystemException {
        this.log("Copying " + fileObject + " to " + fileObject2);
        fileObject2.copyFrom(fileObject, Selectors.SELECT_SELF);
        if (this.preserveLastModified && fileObject.getFileSystem().hasCapability(Capability.GET_LAST_MODIFIED) && fileObject2.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE)) {
            long l = fileObject.getContent().getLastModifiedTime();
            fileObject2.getContent().setLastModifiedTime(l);
        }
    }

    protected void handleUpToDateFile(FileObject fileObject, FileObject fileObject2) throws FileSystemException {
        if (this.overwrite) {
            this.handleOutOfDateFile(fileObject, fileObject2);
        }
    }
}

