/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreElement;
import org.pentaho.metastore.util.MetaStoreUtil;

public class MemoryMetaStoreElementType
implements IMetaStoreElementType {
    private String namespace;
    private String id;
    private String name;
    private String description;
    private String metaStoreName;
    private final Map<String, MemoryMetaStoreElement> elementMap;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;

    public MemoryMetaStoreElementType(String namespace) {
        this.namespace = namespace;
        this.elementMap = new HashMap<String, MemoryMetaStoreElement>();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public MemoryMetaStoreElementType(IMetaStoreElementType elementType) {
        this(elementType.getNamespace());
        this.id = elementType.getId();
        this.name = elementType.getName();
        this.description = elementType.getDescription();
    }

    @Override
    public void save() throws MetaStoreException {
    }

    public Map<String, MemoryMetaStoreElement> getElementMap() {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<Map<String, MemoryMetaStoreElement>>(){

            @Override
            public Map<String, MemoryMetaStoreElement> call() throws Exception {
                return new HashMap<String, MemoryMetaStoreElement>(MemoryMetaStoreElementType.this.elementMap);
            }
        });
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getMetaStoreName() {
        return this.metaStoreName;
    }

    @Override
    public void setMetaStoreName(String metaStoreName) {
        this.metaStoreName = metaStoreName;
    }

    public List<String> getElementIds() {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                ArrayList<String> ids = new ArrayList<String>();
                for (String id : MemoryMetaStoreElementType.this.elementMap.keySet()) {
                    ids.add(id);
                }
                return ids;
            }
        });
    }

    public MemoryMetaStoreElement getElement(final String elementId) {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<MemoryMetaStoreElement>(){

            @Override
            public MemoryMetaStoreElement call() throws Exception {
                return (MemoryMetaStoreElement)MemoryMetaStoreElementType.this.elementMap.get(elementId);
            }
        });
    }

    protected ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.readLock;
    }

    public boolean isElementMapEmpty() {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return MemoryMetaStoreElementType.this.elementMap.isEmpty();
            }
        });
    }

    public List<IMetaStoreElement> getElements() {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<List<IMetaStoreElement>>(){

            @Override
            public List<IMetaStoreElement> call() throws Exception {
                return new ArrayList<IMetaStoreElement>(MemoryMetaStoreElementType.this.elementMap.values());
            }
        });
    }

    public IMetaStoreElement getElementByName(final String elementName) {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<IMetaStoreElement>(){

            @Override
            public IMetaStoreElement call() throws Exception {
                for (MemoryMetaStoreElement element : MemoryMetaStoreElementType.this.elementMap.values()) {
                    if (element.getName() == null || !element.getName().equalsIgnoreCase(elementName)) continue;
                    return element;
                }
                return null;
            }
        });
    }

    public void createElement(final IMetaStoreElement element) {
        if (element.getId() == null) {
            element.setId(element.getName());
        }
        MetaStoreUtil.executeLockedOperationQuietly(this.writeLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreElementType.this.elementMap.put(element.getId(), new MemoryMetaStoreElement(element));
                return null;
            }
        });
    }

    public void updateElement(final String elementId, final IMetaStoreElement element) {
        if (element.getId() == null) {
            element.setId(element.getName());
        }
        MetaStoreUtil.executeLockedOperationQuietly(this.writeLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreElementType.this.elementMap.put(elementId, new MemoryMetaStoreElement(element));
                return null;
            }
        });
    }

    public void deleteElement(final String elementId) {
        MetaStoreUtil.executeLockedOperationQuietly(this.writeLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreElementType.this.elementMap.remove(elementId);
                return null;
            }
        });
    }
}

