/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.io.Console;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;

public class ThriftBinaryCLIService
extends ThriftCLIService {
    public ThriftBinaryCLIService(CLIService cliService) {
        super(cliService, "ThriftBinaryCLIService");
    }

    @Override
    public void run() {
        try {
            TServerSocket serverTransport;
            hiveAuthFactory = new HiveAuthFactory();
            TTransportFactory transportFactory = hiveAuthFactory.getAuthTransFactory();
            TProcessorFactory processorFactory = hiveAuthFactory.getAuthProcFactory(this);
            String portString = System.getenv("HIVE_SERVER2_THRIFT_PORT");
            this.portNum = portString != null ? Integer.valueOf(portString).intValue() : this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT);
            String hiveHost = System.getenv("HIVE_SERVER2_THRIFT_BIND_HOST");
            if (hiveHost == null) {
                hiveHost = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST);
            }
            this.serverAddress = hiveHost != null && !hiveHost.isEmpty() ? new InetSocketAddress(hiveHost, this.portNum) : new InetSocketAddress(this.portNum);
            boolean fSslEnabled = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_SSL);
            if (fSslEnabled) {
                TSSLTransportFactory.TSSLTransportParameters sslParams = new TSSLTransportFactory.TSSLTransportParameters();
                String keyStorePath = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE);
                String keyStorePassword = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD);
                if (keyStorePassword == null || keyStorePassword.isEmpty()) {
                    char[] passwd;
                    String passwordPrompt = "Enter password for keystore: '" + keyStorePath + "': ";
                    Console cons = System.console();
                    if (cons != null && (passwd = cons.readPassword("[%s] ", passwordPrompt)) != null) {
                        keyStorePassword = new String(passwd);
                        Arrays.fill(passwd, ' ');
                    }
                }
                sslParams.setKeyStore(keyStorePath, keyStorePassword);
                serverTransport = TSSLTransportFactory.getServerSocket((int)this.portNum, (int)0, (InetAddress)this.serverAddress.getAddress(), (TSSLTransportFactory.TSSLTransportParameters)sslParams);
                System.out.println("SSL Enabled in HiveServer2");
            } else {
                serverTransport = new TServerSocket(this.serverAddress);
            }
            this.minWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MIN_WORKER_THREADS);
            this.maxWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MAX_WORKER_THREADS);
            TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processorFactory(processorFactory)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(this.minWorkerThreads).maxWorkerThreads(this.maxWorkerThreads);
            this.server = new TThreadPoolServer(sargs);
            LOG.info((Object)("ThriftCLIService " + (fSslEnabled ? "(with SSL) " : "") + "listening on " + this.serverAddress));
            this.server.serve();
        }
        catch (Throwable t) {
            LOG.error((Object)"Error: ", t);
        }
    }
}

