/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.i18n.editor;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterListDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class Translator {
    public static final String APP_NAME = "Pentaho Translator";
    public static final String ROOT = "src/be/ibridge/kettle";
    public static final String EXTENSION = ".properties";
    public static final String MESSAGES_DIR = "messages";
    public static final String MESSAGES_PREFIX = "messages";
    public static final int LOCALE_LENGTH = 5;
    public static final String SYSTEM_KEY_PREFIX = "System";
    public static final String REFERENCE_LOCALE = "en_US";
    private Display display;
    private Shell shell;
    private LogChannelInterface log;
    private PropsUI props;
    private Color unusedColor;
    Hashtable<String, Properties> files;
    private SashForm sashform;
    private List wList;
    private TableView wGrid;
    private Hashtable<String, Integer> directories;
    private Hashtable<String, Boolean> locales;
    private Hashtable<String, String> javaFiles;
    private Button wReload;
    private Button wClose;
    private Button wLocale;
    private Button wVerify;
    private Button wUsed;
    private Button wAvailable;

    public Translator(Display display) {
        this.display = display;
        this.log = new LogChannel((Object)APP_NAME);
        this.props = PropsUI.getInstance();
        this.clear();
        this.unusedColor = display.getSystemColor(7);
    }

    private void clear() {
        this.files = new Hashtable(500);
        this.directories = new Hashtable(100);
        this.javaFiles = new Hashtable(500);
        this.locales = new Hashtable(20);
    }

    public void readFiles(String directory) throws KettleFileException {
        this.log.logBasic("Scanning directory: " + directory);
        try {
            File file = new File(directory);
            File[] entries = file.listFiles();
            for (int i = 0; i < entries.length; ++i) {
                File entry = entries[i];
                if (entry.isDirectory()) {
                    if (entry.getName().startsWith(".svn")) continue;
                    this.readFiles(directory + "/" + entry.getName());
                    continue;
                }
                if (!entry.isFile() || !entry.getName().endsWith(EXTENSION)) continue;
                String filename = directory + "/" + entry.getName();
                this.log.logBasic("Reading properties file: " + filename + "  (" + entry.getAbsolutePath() + ")");
                Properties properties = new Properties();
                properties.load(new FileInputStream(entry));
                this.files.put(filename, properties);
            }
            this.directories = new Hashtable(this.files.size());
            this.locales = new Hashtable(10);
            for (String filename : this.files.keySet()) {
                String path = this.getPath(filename);
                Integer num = this.directories.get(path);
                num = num != null ? Integer.valueOf(num + 1) : Integer.valueOf(1);
                this.directories.put(path, num);
                String locale = this.getLocale(filename);
                this.locales.put(locale, Boolean.TRUE);
                if (locale.charAt(2) == '_') continue;
                this.log.logError("This i18n locale file is not conform the Kettle standard: " + filename);
            }
        }
        catch (Exception e) {
            throw new KettleFileException("Unable to get all files from directory [src/be/ibridge/kettle]", (Throwable)e);
        }
    }

    public void open() {
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setText(APP_NAME);
        try {
            this.readFiles(ROOT);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error reading translations", "There was an unexpected error reading the translations", e);
        }
        this.sashform = new SashForm((Composite)this.shell, 256);
        this.sashform.setLayout((Layout)new FillLayout());
        this.addList();
        this.addGrid();
        this.addListeners();
        this.sashform.setWeights(new int[]{30, 70});
        this.sashform.setVisible(true);
        this.refresh();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
    }

    private void addListeners() {
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = Translator.this.quitFile();
            }
        });
        this.wLocale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Translator.this.selectLocales();
                Translator.this.refreshGrid();
            }
        });
        this.wReload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = Translator.this.wList.getSelectionIndices();
                Translator.this.reload();
                Translator.this.wList.setSelection(idx);
                Translator.this.refreshGrid();
            }
        });
        this.wClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Translator.this.quitFile();
            }
        });
        this.wUsed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Translator.this.refreshGrid();
            }
        });
        this.wAvailable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Translator.this.refreshGrid();
            }
        });
    }

    public void reload() {
        try {
            this.clear();
            this.shell.setCursor(this.display.getSystemCursor(1));
            this.readFiles(ROOT);
            this.shell.setCursor(null);
            this.javaFiles = new Hashtable(500);
            this.refresh();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error loading data", "There was an unexpected error re-loading the data", e);
        }
    }

    public boolean quitFile() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.props.saveProps();
        this.shell.dispose();
        this.display.dispose();
        return true;
    }

    private void addList() {
        Composite composite = new Composite((Composite)this.sashform, 0);
        this.props.setLook((Control)composite);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 5;
        fillLayout.marginHeight = 5;
        composite.setLayout((Layout)fillLayout);
        this.wList = new List(composite, 2818);
        this.wList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Translator.this.refreshGrid();
            }
        });
    }

    private void addGrid() {
        Composite composite = new Composite((Composite)this.sashform, 0);
        this.props.setLook((Control)composite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        composite.setLayout((Layout)formLayout);
        this.wReload = new Button(composite, 0);
        this.wReload.setText("  &Reload  ");
        this.wLocale = new Button(composite, 0);
        this.wLocale.setText("  &Select locale  ");
        this.wClose = new Button(composite, 0);
        this.wClose.setText("  &Close ");
        this.wVerify = new Button(composite, 32);
        this.wVerify.setText("&Verify usage");
        this.wVerify.setSelection(true);
        this.wUsed = new Button(composite, 32);
        this.wUsed.setText("&Remove used keys");
        this.wUsed.setSelection(false);
        this.wAvailable = new Button(composite, 32);
        this.wAvailable.setText("&Check key against other locale");
        this.wAvailable.setSelection(true);
        BaseStepDialog.positionBottomButtons(composite, new Button[]{this.wReload, this.wLocale, this.wClose, this.wVerify, this.wUsed, this.wAvailable}, 4, null);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo("Locale", 1, true), new ColumnInfo("Package", 1, true), new ColumnInfo("Class", 1, true), new ColumnInfo("Key", 1, true), new ColumnInfo("Value", 1, true), new ColumnInfo("Used?", 1, true), new ColumnInfo("Not available in", 1, true)};
        this.wGrid = new TableView(Variables.getADefaultVariableSpace(), composite, 67586, colinf, 0, null, PropsUI.getInstance());
        FormData fdGrid = new FormData();
        fdGrid.left = new FormAttachment(0, 0);
        fdGrid.top = new FormAttachment(0, 0);
        fdGrid.right = new FormAttachment(100, 0);
        fdGrid.bottom = new FormAttachment((Control)this.wReload, -12);
        this.wGrid.setLayoutData(fdGrid);
    }

    public void refresh() {
        this.refreshList();
        this.refreshGrid();
    }

    public void refreshList() {
        ArrayList<String> dirList = new ArrayList<String>(this.directories.keySet());
        Collections.sort(dirList);
        this.wList.removeAll();
        for (int i = 0; i < dirList.size(); ++i) {
            this.wList.add(dirList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshGrid() {
        try {
            if (this.wList.getSelectionCount() > 0) {
                String[] languages = this.getSelectedLocale();
                System.out.println("Selected languages: " + languages.length);
                this.shell.setCursor(this.display.getSystemCursor(1));
                this.wGrid.table.clearAll();
                for (int i = 0; i < this.wList.getSelectionCount(); ++i) {
                    String dir = this.wList.getSelection()[i];
                    for (String filename : this.files.keySet()) {
                        if (!this.getPath(filename).equals(dir)) continue;
                        Properties properties = this.files.get(filename);
                        ArrayList<Object> entryObjects = new ArrayList<Object>(properties.keySet());
                        ArrayList<String> entries = new ArrayList<String>();
                        for (Object object : entryObjects) {
                            entries.add((String)object);
                        }
                        Collections.sort(entries);
                        for (int e = 0; e < entries.size(); ++e) {
                            boolean localeSelected;
                            String entry = (String)entries.get(e);
                            String value = properties.getProperty(entry, "");
                            String locale = this.getLocale(filename);
                            String classname = this.getClassname(entry);
                            String key = entry.length() > classname.length() ? entry.substring(classname.length() + 1) : entry;
                            boolean systemKey = entry.startsWith(SYSTEM_KEY_PREFIX);
                            String fileContent = "";
                            if (this.wVerify.getSelection()) {
                                if (systemKey) {
                                    fileContent = "";
                                } else {
                                    String javaFile = dir + "/" + classname + ".java";
                                    fileContent = this.javaFiles.get(javaFile);
                                    if (fileContent == null) {
                                        fileContent = this.loadJava(javaFile, filename, entry);
                                        this.javaFiles.put(javaFile, fileContent);
                                    }
                                }
                            }
                            if (!(localeSelected = this.locales.get(locale).booleanValue())) continue;
                            String used = "?";
                            if (systemKey) {
                                used = "System key";
                            } else if (this.wVerify.getSelection()) {
                                String keyString = "\"" + entry + "\"";
                                used = fileContent.indexOf(keyString) >= 0 ? "Y" : "N";
                            }
                            boolean notUsed = "N".equalsIgnoreCase(used);
                            if (key.equalsIgnoreCase("Log.FinishedProcessing")) {
                                System.out.println("Debug!");
                            }
                            String available = this.checkAvailability(dir, entry, locale, languages);
                            if (this.wUsed.getSelection() && !notUsed) continue;
                            TableItem item = new TableItem(this.wGrid.table, 0);
                            int pos = 1;
                            item.setText(pos++, locale);
                            item.setText(pos++, dir);
                            item.setText(pos++, classname);
                            item.setText(pos++, key);
                            item.setText(pos++, value);
                            item.setText(pos++, used);
                            item.setText(pos++, available);
                            if (!notUsed) continue;
                            item.setBackground(this.unusedColor);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error loading data", "There was an unexpected error loading data for the translation grid", e);
        }
        finally {
            this.shell.setCursor(null);
        }
        if (this.wGrid.table.getItemCount() == 0) {
            new TableItem(this.wGrid.table, 0);
        }
        this.wGrid.removeEmptyRows();
        this.wGrid.setRowNums();
        this.wGrid.optWidth(true);
        TableColumn col = this.wGrid.table.getColumn(5);
        if (col.getWidth() > 200) {
            col.setWidth(200);
        }
    }

    private String checkAvailability(String dir, String entry, String locale, String[] languages) {
        String available = "Not checked";
        boolean first = true;
        for (int x = 0; x < languages.length; ++x) {
            String propfile = "src/be/ibridge/kettle/" + dir + "/" + "messages" + "/" + "messages" + "_" + languages[x] + EXTENSION;
            String add = null;
            Properties p = this.files.get(propfile);
            if (p == null) {
                add = languages[x] + " : missing file";
            } else {
                String pkey = p.getProperty(entry);
                if (pkey == null) {
                    add = languages[x] + " : missing key";
                }
            }
            if (add == null) continue;
            if (first) {
                available = add;
                first = false;
                continue;
            }
            available = available + ", " + add;
        }
        if (first) {
            available = "All keys are present in the selected " + languages.length + " locale: ";
            for (int a = 0; a < languages.length; ++a) {
                available = a == 0 ? available + languages[a] : available + ", " + languages[a];
            }
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadJava(String javaFile, String propertiesFilename, String entry) throws KettleFileException {
        if (Const.isEmpty((String)entry)) {
            return "";
        }
        try {
            String filename = "src/be/ibridge/kettle/" + javaFile;
            StringBuffer content = new StringBuffer(5000);
            FileInputStream stream = new FileInputStream(filename);
            try {
                int c = 0;
                while ((c = stream.read()) != -1) {
                    content.append((char)c);
                }
            }
            finally {
                stream.close();
            }
            return content.toString();
        }
        catch (Exception e) {
            throw new KettleFileException(propertiesFilename + ": Unable to load file [" + javaFile + "] for key [" + entry + "]", (Throwable)e);
        }
    }

    public String getClassname(String key) {
        int idxDot = key.indexOf(46);
        if (idxDot < 0) {
            return "";
        }
        return key.substring(0, idxDot);
    }

    public String getLocale(String filename) {
        int idx = filename.length() - "messages".length() - 3 - 5;
        return filename.substring(idx, idx + 5);
    }

    private String getPath(String entry) {
        int idxMess;
        String retval = entry;
        int idxRoot = retval.indexOf(ROOT);
        if (idxRoot >= 0) {
            retval = retval.substring(ROOT.length() + 1);
        }
        if ((idxMess = retval.indexOf("/messages/")) >= 0) {
            retval = retval.substring(0, idxMess);
        }
        return retval;
    }

    public String[] getAvailableLocale() {
        Set<String> set = this.locales.keySet();
        return set.toArray(new String[set.size()]);
    }

    public String[] getSelectedLocale() {
        ArrayList<String> selection = new ArrayList<String>();
        String[] locs = this.getAvailableLocale();
        for (int i = 0; i < locs.length; ++i) {
            if (!this.locales.get(locs[i]).booleanValue()) continue;
            selection.add(locs[i]);
        }
        return selection.toArray(new String[selection.size()]);
    }

    public void selectLocales() {
        String[] available = this.getAvailableLocale();
        EnterListDialog eld = new EnterListDialog(this.shell, 0, available);
        String[] selection = eld.open();
        if (selection != null) {
            int i;
            for (i = 0; i < available.length; ++i) {
                this.locales.put(available[i], Boolean.FALSE);
            }
            for (i = 0; i < selection.length; ++i) {
                this.locales.put(selection[i], Boolean.TRUE);
            }
        }
    }

    public String toString() {
        return APP_NAME;
    }

    public static void main(String[] args) {
        Display display = new Display();
        LogChannel log = new LogChannel((Object)APP_NAME);
        PropsUI.init(display, 1);
        Translator translator = new Translator(display);
        translator.open();
        try {
            while (!display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Throwable e) {
            log.logError("An unexpected error occurred : " + e.getMessage());
            log.logError(Const.getStackTracker((Throwable)e));
        }
    }
}

