/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.rules;

import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.steps.rules.RulesAccumulator;
import org.pentaho.di.trans.steps.rules.RulesAccumulatorMeta;
import org.pentaho.di.ui.trans.step.BaseStepXulDialog;
import org.pentaho.di.ui.trans.steps.rules.RulesAccumulatorMetaMapper;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulRadio;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulTree;

public class RulesAccumulatorDialog
extends BaseStepXulDialog
implements StepDialogInterface {
    private RulesAccumulatorMetaMapper metaMapper;
    private String workingStepname;

    public RulesAccumulatorDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super("org/pentaho/di/ui/trans/steps/rules/accumulatorDialog.xul", parent, (BaseStepMeta)in, tr, sname);
        this.init();
    }

    @Override
    protected final Class<?> getClassForMessages() {
        return RulesAccumulator.class;
    }

    public void init() {
        this.workingStepname = this.stepname;
        this.metaMapper = new RulesAccumulatorMetaMapper();
        this.metaMapper.loadMeta((RulesAccumulatorMeta)this.baseStepMeta);
        ((XulTextbox)this.document.getElementById("step-name")).setValue(this.getStepName());
        ((XulTextbox)this.document.getElementById("rule-file")).setValue(this.metaMapper.getRuleFile());
        ((XulTextbox)this.document.getElementById("rule-definition")).setValue(this.metaMapper.getRuleDefinition());
        ((XulTree)this.document.getElementById("fields-table")).setElements(this.metaMapper.getColumnList());
        if (this.metaMapper.getRuleDefinition() != null && !this.metaMapper.getRuleDefinition().equals("")) {
            this.setRuleSource("definition");
            ((XulRadio)this.document.getElementById("rule-definition-radio-button")).setSelected(true);
        } else {
            this.setRuleSource("file");
            ((XulRadio)this.document.getElementById("rule-file-radio-button")).setSelected(true);
        }
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        try {
            this.bf.createBinding("step-name", "value", (Object)this, "stepName", new BindingConvertor[0]);
            this.bf.createBinding("rule-file", "value", (Object)this.metaMapper, "ruleFile", new BindingConvertor[0]);
            this.bf.createBinding("rule-definition", "value", (Object)this.metaMapper, "ruleDefinition", new BindingConvertor[0]);
            this.bf.createBinding(this.metaMapper.getColumnList(), "children", "fields-table", "elements", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding("rule-file-radio-button", "selected", "rule-file", "!disabled", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding("rule-file-radio-button", "selected", "rule-definition", "disabled", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding("rule-definition-radio-button", "selected", "rule-definition", "!disabled", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding("rule-definition-radio-button", "selected", "rule-file", "disabled", new BindingConvertor[0]).fireSourceChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setStepName(String stepname) {
        this.workingStepname = stepname;
    }

    public String getStepName() {
        return this.workingStepname;
    }

    public void setRuleSource(String ruleSource) {
        this.metaMapper.setRuleSource(ruleSource);
    }

    public void addNewRow() {
        this.metaMapper.addNewRow();
    }

    @Override
    public void onAccept() {
        if (!this.workingStepname.equals(this.stepname)) {
            this.stepname = this.workingStepname;
            this.baseStepMeta.setChanged();
        }
        this.metaMapper.saveMeta((RulesAccumulatorMeta)this.baseStepMeta);
        this.dispose();
    }

    @Override
    public void onCancel() {
        this.setStepName(null);
        this.dispose();
    }
}

