/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.reporting.di;

import com.debortoliwines.openerp.api.Field;

public class OpenERPFieldInfo
implements Cloneable {
    private final String modelName;
    private final String fieldName;
    private final OpenERPFieldInfo parentField;
    private final Field.FieldType fieldType;
    private int instanceNum;
    private String renamedFieldName;
    private final String relatedChildModelName;
    private int sortIndex = 0;
    private int sortDirection = 0;

    public OpenERPFieldInfo(String modelName, int instanceNum, String fieldName, String renamedFieldName, OpenERPFieldInfo parentField, Field.FieldType fieldType, String relatedChildModelName, int sortIndex, int sortDirection) {
        this.modelName = modelName;
        this.fieldName = fieldName;
        this.parentField = parentField;
        this.fieldType = fieldType;
        this.relatedChildModelName = relatedChildModelName;
        this.instanceNum = instanceNum;
        this.renamedFieldName = renamedFieldName;
        this.sortIndex = sortIndex;
        this.sortDirection = sortDirection;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OpenERPFieldInfo) {
            OpenERPFieldInfo target = (OpenERPFieldInfo)obj;
            return target.getModelPathName().equals(this.getModelPathName()) && target.getFieldName().equals(this.getFieldName()) && target.getInstanceNum() == this.getInstanceNum();
        }
        return super.equals(obj);
    }

    public OpenERPFieldInfo clone() {
        return new OpenERPFieldInfo(this.modelName, this.instanceNum, this.fieldName, this.renamedFieldName, this.parentField, this.fieldType, this.relatedChildModelName, this.sortIndex, this.sortDirection);
    }

    public OpenERPFieldInfo getParentField() {
        return this.parentField;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Field.FieldType getFieldType() {
        return this.fieldType;
    }

    public String getRelatedChildModelName() {
        return this.relatedChildModelName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getInstanceNum() {
        return this.instanceNum;
    }

    public void incrementInstanceNum() {
        ++this.instanceNum;
    }

    public void setInstanceNum(int instanceNum) {
        this.instanceNum = instanceNum;
    }

    public String getRenamedFieldName() {
        return this.renamedFieldName;
    }

    public void setRenamedFieldName(String renamedFieldName) {
        this.renamedFieldName = renamedFieldName;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(int sortDirection) {
        this.sortDirection = sortDirection;
    }

    public String getModelPathName() {
        if (this.parentField == null) {
            return "[" + this.modelName + "]";
        }
        return this.parentField.getModelPathName() + ".[" + this.parentField.getFieldName() + "]";
    }
}

