/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.reporting.di;

import com.debortoliwines.openerp.api.Field;
import com.debortoliwines.openerp.api.FieldCollection;
import com.debortoliwines.openerp.api.FilterCollection;
import com.debortoliwines.openerp.api.ObjectAdapter;
import com.debortoliwines.openerp.api.OpeneERPApiException;
import com.debortoliwines.openerp.api.Row;
import com.debortoliwines.openerp.api.RowCollection;
import com.debortoliwines.openerp.api.Session;
import com.debortoliwines.openerp.reporting.di.OpenERPConfiguration;
import com.debortoliwines.openerp.reporting.di.OpenERPFieldInfo;
import com.debortoliwines.openerp.reporting.di.OpenERPFilterInfo;
import com.debortoliwines.openerp.reporting.di.OpenERPQueryItem;
import java.beans.DefaultPersistenceDelegate;
import java.beans.XMLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.apache.xmlrpc.XmlRpcException;

public class OpenERPHelper {
    private HashMap<String, ObjectAdapter> objectAdapterCache = new HashMap();
    private Session currentSession = null;
    private OpenERPConfiguration sessionConfig = null;
    private final String GET_FIELDS_PARAM = "getFields";

    public Object[][] getData(OpenERPConfiguration config, HashMap<String, Object> parameters) throws Exception {
        if (config.getDataSource() == OpenERPConfiguration.DataSource.STANDARD) {
            ArrayList<OpenERPFieldInfo> selectedFields = config.getSelectedFields();
            OpenERPQueryItem root = this.buildQueryItems(config.getModelName(), selectedFields, config.getFilters());
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<SortField> sortFields = new ArrayList<SortField>();
            for (int i = 0; i < selectedFields.size(); ++i) {
                OpenERPFieldInfo field = selectedFields.get(i);
                fields.add(field.getModelPathName() + "-|-" + field.getInstanceNum() + "-|-" + field.getFieldName());
                if (field.getSortIndex() <= 0) continue;
                sortFields.add(new SortField(i, field.getFieldType(), field.getSortIndex(), field.getSortDirection()));
            }
            Collections.sort(sortFields, new SourceFieldIndexComparator());
            ArrayList<Object[]> results = this.getSearchData(fields, this.getSession(config), root, null);
            if (sortFields.size() > 0) {
                Collections.sort(results, new ResultSortComparator(sortFields));
            }
            return (Object[][])results.toArray((T[])new Object[0][]);
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        HashMap params = (HashMap)parameters.clone();
        FieldCollection fields = this.getCustomFields(config, params);
        params.put("getFields", false);
        ObjectAdapter adapter = this.getObjectAdapter(config, config.getModelName());
        RowCollection results = adapter.callFunction(config.getCustomFunctionName(), new Object[]{params}, fields);
        for (Row result : results) {
            Object[] row = new Object[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                row[i] = result.get((Field)fields.get(i));
            }
            rows.add(row);
        }
        return (Object[][])rows.toArray((T[])new Object[0][]);
    }

    public ArrayList<OpenERPFieldInfo> getFields(OpenERPConfiguration config, HashMap<String, Object> parameters) throws Exception {
        if (config.getDataSource() == OpenERPConfiguration.DataSource.STANDARD) {
            return config.getSelectedFields();
        }
        ArrayList<OpenERPFieldInfo> customFields = new ArrayList<OpenERPFieldInfo>();
        FieldCollection fields = this.getCustomFields(config, parameters);
        for (Field fld : fields) {
            customFields.add(new OpenERPFieldInfo(config.getModelName(), 1, fld.getName(), fld.getName(), null, fld.getType(), null, 0, 0));
        }
        return customFields;
    }

    private FieldCollection getCustomFields(OpenERPConfiguration config, HashMap<String, Object> parameters) throws Exception {
        HashMap params = (HashMap)parameters.clone();
        params.put("getFields", true);
        ObjectAdapter adapter = this.getObjectAdapter(config, config.getModelName());
        FieldCollection fields = adapter.callFieldsFunction(config.getCustomFunctionName(), new Object[]{params});
        return fields;
    }

    private ArrayList<Object[]> getSearchData(ArrayList<String> fields, Session s, OpenERPQueryItem item, Object relatedFieldValue) throws XmlRpcException, OpeneERPApiException {
        ArrayList<Object[]> finalRows = new ArrayList<Object[]>();
        if (!this.objectAdapterCache.containsKey(item.getModelName())) {
            this.objectAdapterCache.put(item.getModelName(), new ObjectAdapter(s, item.getModelName()));
        }
        ObjectAdapter adapter = this.objectAdapterCache.get(item.getModelName());
        RowCollection adapterRows = null;
        FilterCollection filters = new FilterCollection();
        ArrayList<OpenERPFilterInfo> itemAdditionalFilters = item.getFilters();
        if (itemAdditionalFilters != null) {
            for (OpenERPFilterInfo filter : itemAdditionalFilters) {
                if (filter.getOperator().equalsIgnoreCase("not")) {
                    filters.add(FilterCollection.FilterOperator.NOT);
                } else if (filter.getOperator().equalsIgnoreCase("or")) {
                    filters.add(FilterCollection.FilterOperator.OR);
                }
                try {
                    filters.add(filter.getFieldName(), filter.getComparator(), filter.getValue());
                }
                catch (OpeneERPApiException e) {
                    e.printStackTrace();
                }
            }
        }
        if (relatedFieldValue != null) {
            Object[] idList = null;
            idList = item.getRelationType() == Field.FieldType.MANY2ONE && relatedFieldValue instanceof Object[] && ((Object[])relatedFieldValue).length == 2 ? new Object[]{((Object[])relatedFieldValue)[0]} : (Object[])relatedFieldValue;
            if (filters.size() == 0) {
                adapterRows = adapter.readObject(idList, item.getFields().toArray(new String[0]));
            } else {
                if (item.getRelationType() == Field.FieldType.MANY2ONE) {
                    filters.add(0, "id", "=", idList[0]);
                } else {
                    filters.add(0, "id", "in", (Object)idList);
                }
                adapterRows = adapter.searchAndReadObject(filters, item.getFields().toArray(new String[0]));
            }
        } else {
            adapterRows = adapter.searchAndReadObject(filters, item.getFields().toArray(new String[0]));
        }
        for (Row adapterRow : adapterRows) {
            ArrayList<Object[]> localRows = new ArrayList<Object[]>();
            Object[] localRow = new Object[fields.size()];
            for (String fieldName : item.getFields()) {
                String key = item.getModelPath() + "-|-" + item.getInstanceNum() + "-|-" + fieldName;
                int fieldIndex = fields.indexOf(key);
                if (fieldIndex < 0) continue;
                localRow[fieldIndex] = adapterRow.get(fieldName);
            }
            localRows.add(localRow);
            for (OpenERPQueryItem child : item.getChildItems()) {
                ArrayList<Object> childRows = new ArrayList();
                Object childIDs = adapterRow.get(child.getRelatedField());
                if (childIDs != null) {
                    childRows = this.getSearchData(fields, s, child, childIDs);
                }
                ArrayList<Object[]> combinedRows = new ArrayList<Object[]>();
                if (childRows.size() > 0) {
                    for (Object[] row : localRows) {
                        for (Object[] objectArray : childRows) {
                            Object[] combinedRow = Arrays.copyOf(row, localRow.length);
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (objectArray[i] == null) continue;
                                combinedRow[i] = objectArray[i];
                            }
                            combinedRows.add(combinedRow);
                        }
                    }
                }
                boolean hasFilter = false;
                if (child.getFilters().size() > 0) {
                    hasFilter = true;
                } else {
                    for (OpenERPQueryItem childChildren : child.getAllChildItems()) {
                        if (childChildren.getFilters().size() <= 0) continue;
                        hasFilter = true;
                    }
                }
                if (hasFilter) {
                    localRows = combinedRows;
                    continue;
                }
                if (combinedRows.size() <= 0) continue;
                localRows = combinedRows;
            }
            finalRows.addAll(localRows);
        }
        return finalRows;
    }

    public OpenERPQueryItem buildQueryItems(String modelName, ArrayList<OpenERPFieldInfo> selectedFields, ArrayList<OpenERPFilterInfo> filters) {
        OpenERPQueryItem root = new OpenERPQueryItem("", Field.FieldType.ONE2MANY, modelName, 1);
        root.setFilters(this.getFilter(filters, root.getModelPath(), root.getInstanceNum()));
        for (OpenERPFieldInfo path : selectedFields) {
            this.buildQueryItems(root, path, filters);
        }
        return root;
    }

    private OpenERPQueryItem buildQueryItems(OpenERPQueryItem rootItem, OpenERPFieldInfo field, ArrayList<OpenERPFilterInfo> filters) {
        if (field == null) {
            return null;
        }
        OpenERPQueryItem parentItem = this.buildQueryItems(rootItem, field.getParentField(), filters);
        OpenERPQueryItem item = null;
        if (parentItem == null) {
            item = rootItem;
        } else {
            String relatedfield = field.getParentField().getFieldName();
            item = parentItem.getChildQuery(relatedfield, field.getInstanceNum());
            if (item == null) {
                item = new OpenERPQueryItem(relatedfield, field.getParentField().getFieldType(), field.getModelName(), field.getInstanceNum());
                parentItem.addChildQuery(item);
                item.setFilters(this.getFilter(filters, item.getModelPath(), item.getInstanceNum()));
            }
        }
        item.addField(field.getFieldName());
        return item;
    }

    private ArrayList<OpenERPFilterInfo> getFilter(ArrayList<OpenERPFilterInfo> filters, String modelPath, int instanceNum) {
        ArrayList<OpenERPFilterInfo> filterList = new ArrayList<OpenERPFilterInfo>();
        if (filters != null) {
            for (OpenERPFilterInfo item : filters) {
                if (item.getModelPath() == null || !item.getModelPath().equals(modelPath) || item.getInstanceNum() != instanceNum) continue;
                filterList.add(item);
            }
        }
        return filterList;
    }

    public Session getSession(OpenERPConfiguration config) throws Exception {
        if (!(this.currentSession != null && this.sessionConfig != null && this.sessionConfig.getHostName().equals(config.getHostName()) && this.sessionConfig.getPortNumber() == config.getPortNumber() && this.sessionConfig.getDatabaseName().equals(config.getDatabaseName()) && this.sessionConfig.getUserName().equals(config.getUserName()) && this.sessionConfig.getPassword().equals(config.getPassword()))) {
            this.currentSession = new Session(config.getHostName(), config.getPortNumber(), config.getDatabaseName(), config.getUserName(), config.getPassword());
            this.currentSession.startSession();
        }
        return this.currentSession;
    }

    public ObjectAdapter getObjectAdapter(OpenERPConfiguration config, String modelName) throws Exception {
        Session s = this.getSession(config);
        return new ObjectAdapter(s, modelName);
    }

    public void setupXMLEncoder(XMLEncoder encoder) {
        encoder.setPersistenceDelegate(OpenERPFieldInfo.class, new DefaultPersistenceDelegate(new String[]{"modelName", "instanceNum", "fieldName", "renamedFieldName", "parentField", "fieldType", "relatedChildModelName", "sortIndex", "sortDirection"}));
    }

    private class ResultSortComparator
    implements Comparator<Object[]> {
        private final ArrayList<SortField> sortFields;

        public ResultSortComparator(ArrayList<SortField> sortFields) {
            this.sortFields = sortFields;
        }

        @Override
        public int compare(Object[] arg0, Object[] arg1) {
            return this.compareLevel(arg0, arg1, 0);
        }

        private int compareValues(Object sourceValue, Object targetValue, Field.FieldType fieldType) {
            if (sourceValue == null && targetValue == null) {
                return 0;
            }
            if (sourceValue == null && targetValue != null) {
                return -1;
            }
            if (sourceValue != null && targetValue == null) {
                return 1;
            }
            switch (fieldType) {
                case BINARY: 
                case CHAR: 
                case TEXT: 
                case SELECTION: {
                    return sourceValue.toString().toLowerCase().compareTo(targetValue.toString().toLowerCase());
                }
                case INTEGER: {
                    return ((Integer)sourceValue).compareTo((Integer)targetValue);
                }
                case BOOLEAN: {
                    return ((Boolean)sourceValue).compareTo((Boolean)targetValue);
                }
                case FLOAT: {
                    return ((Double)sourceValue).compareTo((Double)targetValue);
                }
                case DATE: 
                case DATETIME: {
                    return ((Date)sourceValue).compareTo((Date)targetValue);
                }
                case MANY2ONE: {
                    return ((Integer)((Object[])sourceValue)[0]).compareTo((Integer)((Object[])targetValue)[0]);
                }
                case MANY2MANY: 
                case ONE2MANY: {
                    return ((Integer)((Object[])sourceValue)[0]).compareTo((Integer)((Object[])targetValue)[0]);
                }
            }
            return 0;
        }

        private int compareLevel(Object[] arg0, Object[] arg1, int sortLevel) {
            SortField sortField = this.sortFields.get(sortLevel);
            int comparison = this.compareValues(arg0[sortField.getSourceFieldIndex()], arg1[sortField.getSourceFieldIndex()], sortField.getSourceFieldType());
            if (sortField.getSortDirection() == 1) {
                comparison *= -1;
            }
            if (comparison == 0 && sortLevel + 1 < this.sortFields.size()) {
                return this.compareLevel(arg0, arg1, sortLevel + 1);
            }
            return comparison;
        }
    }

    private class SourceFieldIndexComparator
    implements Comparator<SortField> {
        private SourceFieldIndexComparator() {
        }

        @Override
        public int compare(SortField arg0, SortField arg1) {
            Integer source = new Integer(arg0.getSortIndex());
            Integer target = new Integer(arg1.getSortIndex());
            return source.compareTo(target);
        }
    }

    private class SortField {
        private final int sourceFieldIndex;
        private final Field.FieldType sourceFieldType;
        private final int sortIndex;
        private final int sortDirection;

        public SortField(int sourceFieldIndex, Field.FieldType sourceFieldType, int sortIndex, int sortDirection) {
            this.sourceFieldIndex = sourceFieldIndex;
            this.sourceFieldType = sourceFieldType;
            this.sortIndex = sortIndex;
            this.sortDirection = sortDirection;
        }

        public int getSourceFieldIndex() {
            return this.sourceFieldIndex;
        }

        public int getSortDirection() {
            return this.sortDirection;
        }

        public int getSortIndex() {
            return this.sortIndex;
        }

        public Field.FieldType getSourceFieldType() {
            return this.sourceFieldType;
        }
    }
}

