/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.lambda.streams;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.hydromatic.lambda.functions.BiBlock;
import net.hydromatic.lambda.functions.BiMapper;
import net.hydromatic.lambda.functions.BiPredicate;
import net.hydromatic.lambda.functions.BiPredicates;
import net.hydromatic.lambda.functions.BiValue;
import net.hydromatic.lambda.functions.Factory;
import net.hydromatic.lambda.functions.Mapper;
import net.hydromatic.lambda.functions.Mappers;
import net.hydromatic.lambda.functions.Predicate;
import net.hydromatic.lambda.streams.Iterables;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Linq4j;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MapStream<K, V>
extends Iterable<BiValue<K, V>> {
    public boolean isEmpty();

    public Iterable<K> inputs();

    public Iterable<V> values();

    public Iterable<BiValue<K, V>> asIterable();

    public BiValue<K, V> getFirst();

    public BiValue<K, V> getOnly();

    public BiValue<K, V> getAny();

    public MapStream<K, Iterable<V>> asMultiStream();

    public void forEach(BiBlock<? super K, ? super V> var1);

    public MapStream<K, V> filter(BiPredicate<? super K, ? super V> var1);

    public MapStream<K, V> filterKeys(Predicate<K> var1);

    public MapStream<K, V> filterValues(Predicate<V> var1);

    public <W> MapStream<K, W> map(BiMapper<K, V, W> var1);

    public <W> MapStream<K, W> mapValues(Mapper<V, W> var1);

    public <W> MapStream<K, Iterable<W>> mapValuesMulti(BiMapper<? super K, ? super V, Iterable<W>> var1);

    public <A extends Map<? super K, ? super V>> A into(A var1);

    public <A extends Map<? super K, C>, C extends Collection<? super V>> A intoMulti(A var1, Factory<C> var2);

    public boolean anyMatch(BiPredicate<? super K, ? super V> var1);

    public boolean allMatch(BiPredicate<? super K, ? super V> var1);

    public boolean noneMatch(BiPredicate<? super K, ? super V> var1);

    public MapStream<K, V> sorted(Comparator<? super K> var1);

    public MapStream<V, K> swap();

    public MapStream<K, V> merge(MapStream<K, V> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BiVal<K, V>
    implements BiValue<K, V> {
        private final K k;
        private final V v;

        BiVal(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        public static <K, V> BiVal<K, V> of(K k, V v) {
            return new BiVal<K, V>(k, v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractMapStream<K, V>
    implements MapStream<K, V> {
        @Override
        public boolean isEmpty() {
            return Impl.isEmpty(this);
        }

        @Override
        public boolean allMatch(BiPredicate<? super K, ? super V> biPredicate) {
            return Impl.allMatch(this, biPredicate);
        }

        @Override
        public BiValue<K, V> getFirst() {
            return Impl.getFirst(this);
        }

        @Override
        public BiValue<K, V> getOnly() {
            return Impl.getOnly(this);
        }

        @Override
        public BiValue<K, V> getAny() {
            return Impl.getAny(this);
        }

        @Override
        public MapStream<K, Iterable<V>> asMultiStream() {
            return Impl.asMultiStream(this);
        }

        @Override
        public void forEach(BiBlock<? super K, ? super V> biBlock) {
            Impl.forEach(this, biBlock);
        }

        @Override
        public MapStream<K, V> filter(BiPredicate<? super K, ? super V> biPredicate) {
            return Impl.filter(this, biPredicate);
        }

        @Override
        public MapStream<K, V> filterKeys(Predicate<K> filter) {
            return Impl.filterKeys(this, filter);
        }

        @Override
        public MapStream<K, V> filterValues(Predicate<V> filter) {
            return Impl.filterValues(this, filter);
        }

        @Override
        public <W> MapStream<K, W> map(BiMapper<K, V, W> kvwBiMapper) {
            return Impl.map(this, kvwBiMapper);
        }

        @Override
        public <W> MapStream<K, W> mapValues(Mapper<V, W> vwMapper) {
            return Impl.mapValues(this, vwMapper);
        }

        @Override
        public <W> MapStream<K, Iterable<W>> mapValuesMulti(BiMapper<? super K, ? super V, Iterable<W>> iterableBiMapper) {
            return Impl.mapValuesMulti(this, iterableBiMapper);
        }

        @Override
        public <A extends Map<? super K, ? super V>> A into(A destination) {
            return Impl.into(this, destination);
        }

        @Override
        public <A extends Map<? super K, C>, C extends Collection<? super V>> A intoMulti(A destination, Factory<C> factory) {
            return Impl.intoMulti(this, destination, factory);
        }

        @Override
        public boolean anyMatch(BiPredicate<? super K, ? super V> biPredicate) {
            return Impl.anyMatch(this, biPredicate);
        }

        @Override
        public boolean noneMatch(BiPredicate<? super K, ? super V> biPredicate) {
            return !Impl.anyMatch(this, biPredicate);
        }

        @Override
        public MapStream<K, V> sorted(Comparator<? super K> comparator) {
            return Impl.sorted(this, comparator);
        }

        @Override
        public MapStream<V, K> swap() {
            return Impl.swap(this);
        }

        @Override
        public MapStream<K, V> merge(MapStream<K, V> other) {
            return Impl.merge(this, other);
        }

        @Override
        public Iterator<BiValue<K, V>> iterator() {
            return this.asIterable().iterator();
        }

        @Override
        public Iterable<K> inputs() {
            return Impl.inputs(this);
        }

        @Override
        public Iterable<V> values() {
            return Impl.values(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Impl {
        public static <K, V> BiValue<K, V> getFirst(MapStream<K, V> s) {
            Iterator<BiValue<K, V>> iterator = s.asIterable().iterator();
            return iterator.hasNext() ? iterator.next() : null;
        }

        public static <K, V> BiValue<K, V> getOnly(MapStream<K, V> s) {
            return Iterables.only(s.asIterable());
        }

        public static <K, V> MapStream<K, Iterable<V>> asMultiStream(MapStream<K, V> s) {
            return s.mapValues(new Mapper<V, Iterable<V>>(){

                @Override
                public Iterable<V> map(V v) {
                    return Collections.singletonList(v);
                }

                @Override
                public <W> Mapper<V, W> compose(Mapper<? super Iterable<V>, ? extends W> after) {
                    return Mappers.chain(this, after);
                }
            });
        }

        public static <K, V> void forEach(MapStream<K, V> s, BiBlock<? super K, ? super V> block) {
            for (BiValue<K, V> each : s.asIterable()) {
                block.apply(each.getKey(), each.getValue());
            }
        }

        public static <K, V> MapStream<K, V> filter(final MapStream<K, V> s, final BiPredicate<? super K, ? super V> predicate) {
            return new AbstractMapStream<K, V>(){

                @Override
                public Iterable<BiValue<K, V>> asIterable() {
                    final Enumerator enumerator = Linq4j.iterableEnumerator(s);
                    final Enumerator enumerator2 = new Enumerator<BiValue<K, V>>(){

                        @Override
                        public BiValue<K, V> current() {
                            return (BiValue)enumerator.current();
                        }

                        @Override
                        public boolean moveNext() {
                            while (enumerator.moveNext()) {
                                BiValue o = (BiValue)enumerator.current();
                                if (!predicate.eval(o.getKey(), o.getValue())) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public void reset() {
                            enumerator.reset();
                        }

                        @Override
                        public void close() {
                            enumerator.close();
                        }
                    };
                    return new Iterable<BiValue<K, V>>(){

                        @Override
                        public Iterator<BiValue<K, V>> iterator() {
                            return Linq4j.enumeratorIterator(enumerator2);
                        }
                    };
                }
            };
        }

        public static <K, V> MapStream<K, V> sorted(MapStream<K, V> s, Comparator<? super K> comparator) {
            TreeMap result = new TreeMap(comparator);
            for (BiValue biValue : s) {
                result.put(biValue.getKey(), biValue.getValue());
            }
            return Impl.of(result.entrySet());
        }

        public static <K, V> MapStream<V, K> swap(final MapStream<K, V> s) {
            return new AbstractMapStream<V, K>(){

                @Override
                public Iterable<BiValue<V, K>> asIterable() {
                    return new Iterable<BiValue<V, K>>(){
                        final Iterator<BiValue<K, V>> x;
                        {
                            this.x = s.asIterable().iterator();
                        }

                        @Override
                        public Iterator<BiValue<V, K>> iterator() {
                            return new Iterator<BiValue<V, K>>(){

                                @Override
                                public boolean hasNext() {
                                    return x.hasNext();
                                }

                                @Override
                                public BiValue<V, K> next() {
                                    BiValue o = x.next();
                                    return BiVal.of(o.getValue(), o.getKey());
                                }

                                @Override
                                public void remove() {
                                    x.remove();
                                }
                            };
                        }
                    };
                }
            };
        }

        public static <K, V> boolean anyMatch(MapStream<K, V> s, BiPredicate<? super K, ? super V> biPredicate) {
            for (BiValue<K, V> each : s.asIterable()) {
                if (!biPredicate.eval(each.getKey(), each.getValue())) continue;
                return true;
            }
            return false;
        }

        public static <K, V> boolean isEmpty(MapStream<K, V> s) {
            Iterator iterator = s.iterator();
            return !iterator.hasNext();
        }

        public static <K, V> boolean allMatch(MapStream<K, V> s, BiPredicate<? super K, ? super V> biPredicate) {
            for (BiValue<K, V> each : s.asIterable()) {
                if (!biPredicate.eval(each.getKey(), each.getValue())) continue;
                return false;
            }
            return true;
        }

        public static <K, V> BiValue<K, V> getAny(MapStream<K, V> s) {
            return s.getFirst();
        }

        public static <K, V> MapStream<K, V> filterKeys(MapStream<K, V> s, final Predicate<K> filter) {
            return Impl.filter(s, new BiPredicates.AbstractBiPredicate<K, V>(){

                @Override
                public boolean eval(K k, V v) {
                    return filter.test(k);
                }
            });
        }

        public static <K, V> MapStream<K, V> filterValues(MapStream<K, V> s, final Predicate<V> filter) {
            return Impl.filter(s, new BiPredicates.AbstractBiPredicate<K, V>(){

                @Override
                public boolean eval(K k, V v) {
                    return filter.test(v);
                }
            });
        }

        public static <K, V, W> MapStream<K, W> mapValues(final MapStream<K, V> s, final Mapper<V, W> mapper) {
            return new AbstractMapStream<K, W>(){

                @Override
                public Iterable<BiValue<K, W>> asIterable() {
                    return new Iterable<BiValue<K, W>>(){

                        @Override
                        public Iterator<BiValue<K, W>> iterator() {
                            final Iterator x = s.iterator();
                            return new Iterator<BiValue<K, W>>(){

                                @Override
                                public boolean hasNext() {
                                    return x.hasNext();
                                }

                                @Override
                                public BiValue<K, W> next() {
                                    BiValue next = (BiValue)x.next();
                                    Object key = next.getKey();
                                    Object value = next.getValue();
                                    return BiVal.of(key, mapper.map(value));
                                }

                                @Override
                                public void remove() {
                                    x.remove();
                                }
                            };
                        }
                    };
                }
            };
        }

        public static <K, V, W> MapStream<K, Iterable<W>> mapValuesMulti(final MapStream<K, V> s, final BiMapper<? super K, ? super V, Iterable<W>> iterableBiMapper) {
            return new AbstractMapStream<K, Iterable<W>>(){

                @Override
                public Iterable<BiValue<K, Iterable<W>>> asIterable() {
                    return new Iterable<BiValue<K, Iterable<W>>>(){

                        @Override
                        public Iterator<BiValue<K, Iterable<W>>> iterator() {
                            final Iterator x = s.iterator();
                            return new Iterator<BiValue<K, Iterable<W>>>(){

                                @Override
                                public boolean hasNext() {
                                    return x.hasNext();
                                }

                                @Override
                                public BiValue<K, Iterable<W>> next() {
                                    BiValue next = (BiValue)x.next();
                                    Object key = next.getKey();
                                    return BiVal.of(key, iterableBiMapper.map(key, next.getValue()));
                                }

                                @Override
                                public void remove() {
                                    x.remove();
                                }
                            };
                        }
                    };
                }
            };
        }

        public static <K, V, W> MapStream<K, W> map(final MapStream<K, V> s, final BiMapper<K, V, W> mapper) {
            return new AbstractMapStream<K, W>(){

                @Override
                public Iterable<BiValue<K, W>> asIterable() {
                    return new Iterable<BiValue<K, W>>(){

                        @Override
                        public Iterator<BiValue<K, W>> iterator() {
                            final Iterator x = s.iterator();
                            return new Iterator<BiValue<K, W>>(){

                                @Override
                                public boolean hasNext() {
                                    return x.hasNext();
                                }

                                @Override
                                public BiValue<K, W> next() {
                                    BiValue next = (BiValue)x.next();
                                    Object k = next.getKey();
                                    Object v = next.getValue();
                                    return BiVal.of(k, mapper.map(k, v));
                                }

                                @Override
                                public void remove() {
                                    x.remove();
                                }
                            };
                        }
                    };
                }
            };
        }

        public static <K, V> Iterable<K> inputs(MapStream<K, V> s) {
            final Iterable<BiValue<K, V>> filteredElements = s.asIterable();
            return new Iterable<K>(){

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        final Iterator<? extends BiValue<K, V>> source;
                        {
                            this.source = filteredElements.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.source.hasNext();
                        }

                        @Override
                        public K next() {
                            return this.source.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.source.remove();
                        }
                    };
                }
            };
        }

        public static <K, V> Iterable<V> values(MapStream<K, V> s) {
            final Iterable<BiValue<K, V>> filteredElements = s.asIterable();
            return new Iterable<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        final Iterator<? extends BiValue<K, V>> source;
                        {
                            this.source = filteredElements.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.source.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.source.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.source.remove();
                        }
                    };
                }
            };
        }

        public static <K, V> MapStream<K, V> merge(MapStream<K, V> s, MapStream<K, V> other) {
            HashMap union = new HashMap();
            s.into(union);
            other.into(union);
            return Impl.of(union.entrySet());
        }

        public static <K, V, A extends Map<? super K, ? super V>> A into(MapStream<K, V> s, A destination) {
            for (BiValue biValue : s) {
                destination.put(biValue.getKey(), biValue.getValue());
            }
            return destination;
        }

        public static <K, V, A extends Map<? super K, C>, C extends Collection<? super V>> A intoMulti(MapStream<K, V> s, A destination, Factory<C> factory) {
            for (BiValue biValue : s) {
                Collection c = (Collection)factory.make();
                c.add(biValue.getValue());
                destination.put(biValue.getKey(), (Collection)c);
            }
            return destination;
        }

        public static <K, V> MapStream<K, V> of(final Iterable<Map.Entry<K, V>> iterable) {
            return new AbstractMapStream<K, V>(){

                @Override
                public Iterable<BiValue<K, V>> asIterable() {
                    return new Iterable<BiValue<K, V>>(){
                        final Iterator<Map.Entry<K, V>> x;
                        {
                            this.x = iterable.iterator();
                        }

                        @Override
                        public Iterator<BiValue<K, V>> iterator() {
                            return new Iterator<BiValue<K, V>>(){

                                @Override
                                public boolean hasNext() {
                                    return x.hasNext();
                                }

                                @Override
                                public BiValue<K, V> next() {
                                    Map.Entry o = x.next();
                                    return BiVal.of(o.getKey(), o.getValue());
                                }

                                @Override
                                public void remove() {
                                    x.remove();
                                }
                            };
                        }
                    };
                }
            };
        }
    }
}

