/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class CoordActionsToSkipAfterDowntimeJPAExecutor
implements JPAExecutor<Void> {
    private String coordJobId = null;
    private long startTime = 0L;
    private long endTime = 0L;
    private String recovery = null;

    public CoordActionsToSkipAfterDowntimeJPAExecutor(String id, long start, long end, String recovery) {
        this.coordJobId = id;
        this.startTime = start;
        this.endTime = end;
        this.recovery = recovery;
    }

    @Override
    public String getName() {
        return "CoordActionsToSkipAfterDowntimeJPAExecutor";
    }

    @Override
    public Void execute(EntityManager em) throws JPAExecutorException {
        if (this.recovery.equalsIgnoreCase("ALL")) {
            return null;
        }
        Query q = em.createNamedQuery("GET_COORD_ACTIONS_FOR_DOWNTIME");
        q.setParameter("jobId", (Object)this.coordJobId);
        q.setParameter("endTime", (Object)new Timestamp(this.endTime));
        q.setParameter("startTime", (Object)new Timestamp(this.startTime));
        List objs = q.getResultList();
        boolean isFirst = true;
        for (Object[] arr : objs) {
            if (isFirst) {
                if (this.recovery.equalsIgnoreCase("LAST_ONLY")) {
                    isFirst = false;
                    continue;
                }
                isFirst = false;
            }
            CoordinatorActionBean bean = this.getCoordinatorActionBeanFromArray(arr);
            q = em.createNamedQuery("UPDATE_COORD_ACTION_STATUS_PENDING_TIME");
            q.setParameter("id", (Object)bean.getId());
            q.setParameter("status", (Object)bean.getStatus().toString());
            q.setParameter("lastModifiedTime", (Object)new Date());
            q.setParameter("pending", (Object)bean.getPending());
            q.executeUpdate();
        }
        return null;
    }

    private CoordinatorActionBean getCoordinatorActionBeanFromArray(Object[] arr) {
        CoordinatorActionBean bean = new CoordinatorActionBean();
        if (arr[0] != null) {
            bean.setId((String)arr[0]);
        }
        if (arr[1] != null) {
            bean.setJobId((String)arr[1]);
        }
        if (arr[2] != null) {
            bean.setStatus(CoordinatorAction.Status.SKIPPED);
        }
        if (arr[3] != null) {
            bean.setPending((Integer)arr[3]);
        }
        return bean;
    }
}

