/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla.listener;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.email.EmailActionExecutor;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.sla.listener.SLAEventListener;
import org.apache.oozie.util.XLog;

public class SLAEmailEventListener
extends SLAEventListener {
    public static final String SMTP_CONNECTION_TIMEOUT = "oozie.email.smtp.connectiontimeout";
    public static final String SMTP_TIMEOUT = "oozie.email.smtp.timeout";
    public static final String BLACKLIST_CACHE_TIMEOUT = "oozie.email.blacklist.cachetimeout";
    public static final String BLACKLIST_FAIL_COUNT = "oozie.email.blacklist.failcount";
    public static final String OOZIE_BASE_URL = "oozie.base.url";
    private Session session;
    private String oozieBaseUrl;
    private InternetAddress fromAddr;
    private String ADDRESS_SEPARATOR = ",";
    private LoadingCache<String, AtomicInteger> blackList;
    private int blacklistFailCount;
    private final String BLACKLIST_CACHE_TIMEOUT_DEFAULT = "1800";
    private final String BLACKLIST_FAIL_COUNT_DEFAULT = "2";
    private final String SMTP_HOST_DEFAULT = "localhost";
    private final String SMTP_PORT_DEFAULT = "25";
    private final boolean SMTP_AUTH_DEFAULT = false;
    private final String SMTP_SOURCE_DEFAULT = "oozie@localhost";
    private final String SMTP_CONNECTION_TIMEOUT_DEFAULT = "5000";
    private final String SMTP_TIMEOUT_DEFAULT = "5000";
    private static XLog LOG = XLog.getLog(SLAEmailEventListener.class);
    private Set<SLAEvent.EventStatus> alertEvents;
    public static String EMAIL_BODY_FIELD_SEPARATER = " - ";
    public static String EMAIL_BODY_FIELD_INDENT = "  ";
    public static String EMAIL_BODY_HEADER_SEPARATER = ":";

    @Override
    public void init(Configuration conf) throws Exception {
        this.oozieBaseUrl = conf.get(OOZIE_BASE_URL);
        String smtpHost = conf.get("oozie.email.smtp.host", "localhost");
        String smtpPort = conf.get("oozie.email.smtp.port", "25");
        Boolean smtpAuth = conf.getBoolean("oozie.email.smtp.auth", false);
        String smtpUser = conf.get("oozie.email.smtp.username", "");
        String smtpPassword = conf.get("oozie.email.smtp.password", "");
        String smtpConnectTimeout = conf.get(SMTP_CONNECTION_TIMEOUT, "5000");
        String smtpTimeout = conf.get(SMTP_TIMEOUT, "5000");
        int blacklistTimeOut = Integer.valueOf(conf.get(BLACKLIST_CACHE_TIMEOUT, "1800"));
        this.blacklistFailCount = Integer.valueOf(conf.get(BLACKLIST_FAIL_COUNT, "2"));
        this.blackList = CacheBuilder.newBuilder().expireAfterWrite((long)blacklistTimeOut, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

            public AtomicInteger load(String key) throws Exception {
                return new AtomicInteger();
            }
        });
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", smtpHost);
        properties.setProperty("mail.smtp.port", smtpPort);
        properties.setProperty("mail.smtp.auth", smtpAuth.toString());
        properties.setProperty("mail.smtp.connectiontimeout", smtpConnectTimeout);
        properties.setProperty("mail.smtp.timeout", smtpTimeout);
        try {
            this.fromAddr = new InternetAddress(conf.get("oozie.email.from.address", "oozie@localhost"));
        }
        catch (AddressException ae) {
            LOG.error((Object)"Bad Source Address specified in oozie.email.from.address", ae);
            throw ae;
        }
        this.session = smtpAuth == false ? Session.getInstance((Properties)properties) : Session.getInstance((Properties)properties, (Authenticator)new EmailActionExecutor.JavaMailAuthenticator(smtpUser, smtpPassword));
        this.alertEvents = new HashSet<SLAEvent.EventStatus>();
        String alertEventsStr = conf.get("oozie.sla.service.SLAService.alert.events");
        if (alertEventsStr != null) {
            String[] alertEvt;
            for (String evt : alertEvt = alertEventsStr.split(",", -1)) {
                this.alertEvents.add(SLAEvent.EventStatus.valueOf((String)evt));
            }
        }
    }

    @Override
    public void destroy() {
    }

    private void sendSLAEmail(SLAEvent event) throws Exception {
        MimeMessage message = new MimeMessage(this.session);
        this.setMessageHeader((Message)message, event);
        this.setMessageBody((Message)message, event);
        this.sendEmail((Message)message);
    }

    @Override
    public void onStartMiss(SLAEvent event) {
        boolean flag = false;
        if (event.getAlertEvents() == null) {
            flag = this.alertEvents.contains(SLAEvent.EventStatus.START_MISS);
        } else if (event.getAlertEvents().contains(SLAEvent.EventStatus.START_MISS.name())) {
            flag = true;
        }
        if (flag) {
            try {
                this.sendSLAEmail(event);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to send StartMiss alert email", e);
            }
        }
    }

    @Override
    public void onEndMiss(SLAEvent event) {
        boolean flag = false;
        if (event.getAlertEvents() == null) {
            flag = this.alertEvents.contains(SLAEvent.EventStatus.END_MISS);
        } else if (event.getAlertEvents().contains(SLAEvent.EventStatus.END_MISS.name())) {
            flag = true;
        }
        if (flag) {
            try {
                this.sendSLAEmail(event);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to send EndMiss alert email", e);
            }
        }
    }

    @Override
    public void onDurationMiss(SLAEvent event) {
        boolean flag = false;
        if (event.getAlertEvents() == null) {
            flag = this.alertEvents.contains(SLAEvent.EventStatus.DURATION_MISS);
        } else if (event.getAlertEvents().contains(SLAEvent.EventStatus.DURATION_MISS.name())) {
            flag = true;
        }
        if (flag) {
            try {
                this.sendSLAEmail(event);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to send DurationMiss alert email", e);
            }
        }
    }

    private Address[] parseAddress(String str) {
        String[] emails;
        Address[] addrs = null;
        ArrayList<InternetAddress> addrList = new ArrayList<InternetAddress>();
        for (String email : emails = str.split(this.ADDRESS_SEPARATOR, -1)) {
            boolean isBlackListed = false;
            AtomicInteger val = (AtomicInteger)this.blackList.getIfPresent((Object)email);
            if (val != null) {
                boolean bl = isBlackListed = val.get() >= this.blacklistFailCount;
            }
            if (isBlackListed) continue;
            try {
                addrList.add(new InternetAddress(email, true));
            }
            catch (AddressException ae) {
                LOG.error((Object)("Skipping bad destination address: " + email), ae);
            }
        }
        if (addrList.size() > 0) {
            addrs = (Address[])addrList.toArray(new InternetAddress[addrList.size()]);
        }
        return addrs;
    }

    private void setMessageHeader(Message msg, SLAEvent event) throws MessagingException {
        InternetAddress[] from = new InternetAddress[]{this.fromAddr};
        StringBuilder subject = new StringBuilder();
        Address[] to = this.parseAddress(event.getAlertContact());
        if (to == null) {
            LOG.error("Destination address is null or invalid, stop sending SLA alert email");
            throw new IllegalArgumentException("Destination address is not specified properly");
        }
        subject.append("OOZIE - SLA ");
        subject.append(event.getEventStatus().name());
        subject.append(" (AppName=");
        subject.append(event.getAppName());
        subject.append(", JobID=");
        subject.append(event.getId());
        subject.append(")");
        try {
            msg.addFrom((Address[])from);
            msg.addRecipients(MimeMessage.RecipientType.TO, to);
            msg.setSubject(subject.toString());
        }
        catch (MessagingException me) {
            LOG.error((Object)"Message Exception in setting message header of SLA alert email", me);
            throw me;
        }
    }

    private void setMessageBody(Message msg, SLAEvent event) throws MessagingException {
        StringBuilder body = new StringBuilder();
        this.printHeading(body, "Status");
        this.printField(body, EmailField.EVENT_STATUS.toString(), event.getEventStatus());
        this.printField(body, EmailField.JOB_STATUS.toString(), event.getJobStatus());
        this.printField(body, EmailField.NOTIFICATION_MESSAGE.toString(), event.getNotificationMsg());
        this.printHeading(body, "Job Details");
        this.printField(body, EmailField.APP_NAME.toString(), event.getAppName());
        this.printField(body, EmailField.APP_TYPE.toString(), event.getAppType());
        this.printField(body, EmailField.USER.toString(), event.getUser());
        this.printField(body, EmailField.JOBID.toString(), event.getId());
        this.printField(body, EmailField.JOB_URL.toString(), this.getJobLink(event.getId()));
        this.printField(body, EmailField.PARENT_JOBID.toString(), event.getParentId() != null ? event.getParentId() : "N/A");
        this.printField(body, EmailField.PARENT_JOB_URL.toString(), event.getParentId() != null ? this.getJobLink(event.getParentId()) : "N/A");
        this.printField(body, EmailField.UPSTREAM_APPS.toString(), event.getUpstreamApps());
        this.printHeading(body, "SLA Details");
        this.printField(body, EmailField.NOMINAL_TIME.toString(), event.getNominalTime());
        this.printField(body, EmailField.EXPECTED_START_TIME.toString(), event.getExpectedStart());
        this.printField(body, EmailField.ACTUAL_START_TIME.toString(), event.getActualStart());
        this.printField(body, EmailField.EXPECTED_END_TIME.toString(), event.getExpectedEnd());
        this.printField(body, EmailField.ACTUAL_END_TIME.toString(), event.getActualEnd());
        this.printField(body, EmailField.EXPECTED_DURATION.toString(), this.getDurationInMins(event.getExpectedDuration()));
        this.printField(body, EmailField.ACTUAL_DURATION.toString(), this.getDurationInMins(event.getActualDuration()));
        try {
            msg.setText(body.toString());
        }
        catch (MessagingException me) {
            LOG.error((Object)"Message Exception in setting message body of SLA alert email", me);
            throw me;
        }
    }

    private long getDurationInMins(long duration) {
        if (duration < 0L) {
            return duration;
        }
        return duration / 60000L;
    }

    private String getJobLink(String jobId) {
        StringBuffer url = new StringBuffer();
        String param = "/?job=";
        url.append(this.oozieBaseUrl);
        url.append(param);
        url.append(jobId);
        return url.toString();
    }

    private void printField(StringBuilder st, String name, Object value) {
        String lineFeed = "\n";
        if (value != null) {
            st.append(EMAIL_BODY_FIELD_INDENT);
            st.append(name);
            st.append(EMAIL_BODY_FIELD_SEPARATER);
            st.append(value);
            st.append(lineFeed);
        }
    }

    private void printHeading(StringBuilder st, String header) {
        st.append(header);
        st.append(EMAIL_BODY_HEADER_SEPARATER);
        st.append("\n");
    }

    private void sendEmail(Message message) throws MessagingException {
        try {
            Transport.send((Message)message);
        }
        catch (NoSuchProviderException se) {
            LOG.error((Object)"Could not find an SMTP transport provider to email", se);
            throw se;
        }
        catch (MessagingException me) {
            Address[] invalidAddrs;
            LOG.error((Object)"Message Exception in transporting SLA alert email", me);
            if (me instanceof SendFailedException && (invalidAddrs = ((SendFailedException)me).getInvalidAddresses()) != null && invalidAddrs.length > 0) {
                for (Address addr : invalidAddrs) {
                    try {
                        AtomicInteger val = (AtomicInteger)this.blackList.get((Object)addr.toString());
                        val.incrementAndGet();
                    }
                    catch (Exception e) {
                        LOG.debug("blacklist loading throwed exception");
                    }
                }
            }
            throw me;
        }
    }

    @VisibleForTesting
    public void addBlackList(String email) throws Exception {
        if (email == null || email.equals("")) {
            return;
        }
        AtomicInteger val = (AtomicInteger)this.blackList.get((Object)email);
        val.set(this.blacklistFailCount);
    }

    @Override
    public void onStartMet(SLAEvent work) {
    }

    @Override
    public void onEndMet(SLAEvent work) {
    }

    @Override
    public void onDurationMet(SLAEvent work) {
    }

    public static enum EmailField {
        EVENT_STATUS("SLA Status"),
        APP_TYPE("App Type"),
        APP_NAME("App Name"),
        USER("User"),
        JOBID("Job ID"),
        PARENT_JOBID("Parent Job ID"),
        JOB_URL("Job URL"),
        PARENT_JOB_URL("Parent Job URL"),
        NOMINAL_TIME("Nominal Time"),
        EXPECTED_START_TIME("Expected Start Time"),
        ACTUAL_START_TIME("Actual Start Time"),
        EXPECTED_END_TIME("Expected End Time"),
        ACTUAL_END_TIME("Actual End Time"),
        EXPECTED_DURATION("Expected Duration (in mins)"),
        ACTUAL_DURATION("Actual Duration (in mins)"),
        NOTIFICATION_MESSAGE("Notification Message"),
        UPSTREAM_APPS("Upstream Apps"),
        JOB_STATUS("Job Status");

        private String name;

        private EmailField(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

