/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.mapreduce.JdbcUpdateExportJob;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DBOutputFormat;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;

public class JdbcUpsertExportJob
extends JdbcUpdateExportJob {
    public static final Log LOG = LogFactory.getLog((String)JdbcUpsertExportJob.class.getName());

    public JdbcUpsertExportJob(ExportJobContext context, Class<? extends OutputFormat> outputFormatClass) throws IOException {
        super(context, null, null, outputFormatClass);
    }

    @Override
    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws IOException {
        ConnManager mgr = this.context.getConnManager();
        try {
            String username = this.options.getUsername();
            if (null == username || username.length() == 0) {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString());
            } else {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), username, this.options.getPassword());
            }
            String[] colNames = this.options.getColumns();
            if (null == colNames) {
                colNames = mgr.getColumnNames(tableName);
            }
            if (null == colNames) {
                throw new IOException("Export column names could not be determined for " + tableName);
            }
            DBOutputFormat.setOutput(job, tableName, colNames);
            String updateKeyColumns = this.options.getUpdateKeyCol();
            if (null == updateKeyColumns) {
                throw new IOException("Update key column not set in export job");
            }
            LinkedHashSet<String> updateKeys = new LinkedHashSet<String>();
            StringTokenizer stok = new StringTokenizer(updateKeyColumns, ",");
            while (stok.hasMoreTokens()) {
                String nextUpdateKey = stok.nextToken().trim();
                if (nextUpdateKey.length() > 0) {
                    updateKeys.add(nextUpdateKey);
                    continue;
                }
                throw new RuntimeException("Invalid update key column value specified: '" + updateKeyColumns + "'");
            }
            if (updateKeys.size() == 0) {
                throw new IOException("Unpdate key columns not valid in export job");
            }
            job.setOutputFormatClass(this.getOutputFormatClass());
            job.getConfiguration().set("sqoop.mapreduce.export.table.class", tableClassName);
            job.getConfiguration().set("sqoop.mapreduce.export.update.col", updateKeyColumns);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Could not load OutputFormat", cnfe);
        }
    }
}

