/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.orm;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.util.FileListing;
import com.cloudera.sqoop.util.Jars;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobConf;

public class CompilationManager {
    public static final String DEFAULT_CODEGEN_JAR_NAME = "sqoop-codegen-created.jar";
    public static final Log LOG = LogFactory.getLog((String)CompilationManager.class.getName());
    private SqoopOptions options;
    private List<String> sources;
    private static final int BUFFER_SZ = 4096;

    public CompilationManager(SqoopOptions opts) {
        this.options = opts;
        this.sources = new ArrayList<String>();
    }

    public void addSourceFile(String sourceName) {
        this.sources.add(sourceName);
    }

    private String findHadoopCoreJar() {
        String hadoopHome = this.options.getHadoopHome();
        if (null == hadoopHome) {
            LOG.info((Object)"$HADOOP_HOME is not set");
            return Jars.getJarPathForClass(JobConf.class);
        }
        if (!hadoopHome.endsWith(File.separator)) {
            hadoopHome = hadoopHome + File.separator;
        }
        File hadoopHomeFile = new File(hadoopHome);
        LOG.info((Object)("HADOOP_HOME is " + hadoopHomeFile.getAbsolutePath()));
        File[] entries = hadoopHomeFile.listFiles();
        if (null == entries) {
            LOG.warn((Object)"HADOOP_HOME appears empty or missing");
            return Jars.getJarPathForClass(JobConf.class);
        }
        for (File f : entries) {
            if (!f.getName().startsWith("hadoop-") || !f.getName().endsWith("-core.jar")) continue;
            LOG.info((Object)("Found hadoop core jar at: " + f.getAbsolutePath()));
            return f.getAbsolutePath();
        }
        return Jars.getJarPathForClass(JobConf.class);
    }

    public void compile() throws IOException {
        Iterable<? extends JavaFileObject> srcFileObjs;
        JavaCompiler.CompilationTask task;
        boolean result;
        String sqoopJar;
        String coreJar;
        ArrayList<String> args = new ArrayList<String>();
        String jarOutDir = this.options.getJarOutputDir();
        File jarOutDirObj = new File(jarOutDir);
        if (!jarOutDirObj.exists()) {
            boolean mkdirSuccess = jarOutDirObj.mkdirs();
            if (!mkdirSuccess) {
                LOG.debug((Object)("Warning: Could not make directories for " + jarOutDir));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found existing " + jarOutDir));
        }
        if (!jarOutDir.endsWith(File.separator)) {
            jarOutDir = jarOutDir + File.separator;
        }
        if (null == (coreJar = this.findHadoopCoreJar())) {
            String coreClassesPath = System.getProperty("hadoop.alt.classpath");
            if (null == coreClassesPath) {
                throw new IOException("Could not find hadoop core jar!");
            }
            coreJar = coreClassesPath;
        }
        if (null != (sqoopJar = Jars.getSqoopJarPath())) {
            sqoopJar = File.pathSeparator + sqoopJar;
        } else {
            LOG.warn((Object)"Could not find sqoop jar; child compilation may fail");
            sqoopJar = "";
        }
        String curClasspath = System.getProperty("java.class.path");
        args.add("-sourcepath");
        args.add(jarOutDir);
        args.add("-d");
        args.add(jarOutDir);
        args.add("-classpath");
        args.add(curClasspath + File.pathSeparator + coreJar + sqoopJar);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (null == compiler) {
            LOG.error((Object)"It seems as though you are running sqoop with a JRE.");
            LOG.error((Object)"Sqoop requires a JDK that can compile Java code.");
            LOG.error((Object)"Please install a JDK and set $JAVA_HOME to use it.");
            throw new IOException("Could not start Java compiler.");
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        ArrayList<String> srcFileNames = new ArrayList<String>();
        for (String srcfile : this.sources) {
            srcFileNames.add(jarOutDir + srcfile);
            LOG.debug((Object)("Adding source file: " + jarOutDir + srcfile));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Invoking javac with args:");
            for (String arg : args) {
                LOG.debug((Object)("  " + arg));
            }
        }
        if (!(result = (task = compiler.getTask(null, fileManager, null, args, null, srcFileObjs = fileManager.getJavaFileObjectsFromStrings(srcFileNames))).call().booleanValue())) {
            throw new IOException("Error returned by javac");
        }
        String srcOutDir = new File(this.options.getCodeOutputDir()).getAbsolutePath();
        if (!srcOutDir.endsWith(File.separator)) {
            srcOutDir = srcOutDir + File.separator;
        }
        for (String srcFileName : this.sources) {
            String orig = jarOutDir + srcFileName;
            String dest = srcOutDir + srcFileName;
            File fOrig = new File(orig);
            File fDest = new File(dest);
            File fDestParent = fDest.getParentFile();
            if (null != fDestParent && !fDestParent.exists() && !fDestParent.mkdirs()) {
                LOG.error((Object)("Could not make directory: " + fDestParent));
            }
            try {
                FileUtils.moveFile((File)fOrig, (File)fDest);
            }
            catch (IOException e) {
                LOG.error((Object)("Could not rename " + orig + " to " + dest), (Throwable)e);
            }
        }
    }

    public String getJarFilename() {
        String jarOutDir = this.options.getJarOutputDir();
        String tableName = this.options.getTableName();
        String specificClassName = this.options.getClassName();
        if (specificClassName != null && specificClassName.length() > 0) {
            return jarOutDir + specificClassName + ".jar";
        }
        if (null != tableName && tableName.length() > 0) {
            return jarOutDir + tableName + ".jar";
        }
        if (this.sources.size() == 1) {
            String srcFileName = this.sources.get(0);
            String basename = new File(srcFileName).getName();
            String[] parts = basename.split("\\.");
            String preExtPart = parts[0];
            return jarOutDir + preExtPart + ".jar";
        }
        return jarOutDir + DEFAULT_CODEGEN_JAR_NAME;
    }

    private void addClassFilesFromDir(File dir, JarOutputStream jstream) throws IOException {
        LOG.debug((Object)("Scanning for .class files in directory: " + dir));
        List<File> dirEntries = FileListing.getFileListing(dir);
        String baseDirName = dir.getAbsolutePath();
        if (!baseDirName.endsWith(File.separator)) {
            baseDirName = baseDirName + File.separator;
        }
        for (File entry : dirEntries) {
            String fullPath;
            String chompedPath;
            boolean include;
            if (entry.isDirectory() || !(include = (chompedPath = (fullPath = entry.getAbsolutePath()).substring(baseDirName.length())).endsWith(".class") && this.sources.contains(chompedPath.substring(0, chompedPath.length() - ".class".length()) + ".java"))) continue;
            LOG.debug((Object)("Got classfile: " + entry.getPath() + " -> " + chompedPath));
            ZipEntry ze = new ZipEntry(chompedPath);
            jstream.putNextEntry(ze);
            this.copyFileToStream(entry, jstream);
            jstream.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jar() throws IOException {
        String jarOutDir = this.options.getJarOutputDir();
        String jarFilename = this.getJarFilename();
        LOG.info((Object)("Writing jar file: " + jarFilename));
        File jarFileObj = new File(jarFilename);
        if (jarFileObj.exists()) {
            LOG.debug((Object)("Found existing jar (" + jarFilename + "); removing."));
            if (!jarFileObj.delete()) {
                LOG.warn((Object)("Could not remove existing jar file: " + jarFilename));
            }
        }
        FileOutputStream fstream = null;
        ZipOutputStream jstream = null;
        try {
            fstream = new FileOutputStream(jarFilename);
            jstream = new JarOutputStream(fstream);
            this.addClassFilesFromDir(new File(jarOutDir), (JarOutputStream)jstream);
            jstream.finish();
        }
        finally {
            if (null != jstream) {
                try {
                    jstream.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("IOException closing jar stream: " + ioe.toString()));
                }
            }
            if (null != fstream) {
                try {
                    fstream.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("IOException closing file stream: " + ioe.toString()));
                }
            }
        }
        LOG.debug((Object)("Finished writing jar file " + jarFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileToStream(File f, OutputStream ostream) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        byte[] buffer = new byte[4096];
        try {
            int bytesReceived;
            while ((bytesReceived = fis.read(buffer)) >= 1) {
                ostream.write(buffer, 0, bytesReceived);
            }
        }
        finally {
            fis.close();
        }
    }
}

