/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.hbase;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadPushDown;
import org.apache.pig.LoadStoreCaster;
import org.apache.pig.OrderedLoadFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.hbase.HBaseBinaryConverter;
import org.apache.pig.backend.hadoop.hbase.HBaseTableInputFormat;
import org.apache.pig.builtin.Utf8StorageConverter;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.zookeeper.ZooKeeper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HBaseStorage
extends LoadFunc
implements StoreFuncInterface,
LoadPushDown,
OrderedLoadFunc {
    private static final Log LOG = LogFactory.getLog(HBaseStorage.class);
    private static final String STRING_CASTER = "UTF8StorageConverter";
    private static final String BYTE_CASTER = "HBaseBinaryConverter";
    private static final String CASTER_PROPERTY = "pig.hbase.caster";
    private List<byte[][]> columnList_ = Lists.newArrayList();
    private HTable m_table;
    private Configuration m_conf;
    private RecordReader reader;
    private RecordWriter writer;
    private Scan scan;
    private String contextSignature = null;
    private final CommandLine configuredOptions_;
    private static final Options validOptions_ = new Options();
    private static final CommandLineParser parser_ = new GnuParser();
    private boolean loadRowKey_;
    private final long limit_;
    private final int caching_;
    protected transient byte[] gt_;
    protected transient byte[] gte_;
    protected transient byte[] lt_;
    protected transient byte[] lte_;
    private LoadCaster caster_;
    private ResourceSchema schema_;
    private LoadPushDown.RequiredFieldList requiredFieldList;
    private boolean initialized = false;

    private static void populateValidOptions() {
        validOptions_.addOption("loadKey", false, "Load Key");
        validOptions_.addOption("gt", true, "Records must be greater than this value (binary, double-slash-escaped)");
        validOptions_.addOption("lt", true, "Records must be less than this value (binary, double-slash-escaped)");
        validOptions_.addOption("gte", true, "Records must be greater than or equal to this value");
        validOptions_.addOption("lte", true, "Records must be less than or equal to this value");
        validOptions_.addOption("caching", true, "Number of rows scanners should cache");
        validOptions_.addOption("limit", true, "Per-region limit");
        validOptions_.addOption("caster", true, "Caster to use for converting values. A class name, HBaseBinaryConverter, or Utf8StorageConverter. For storage, casters must implement LoadStoreCaster.");
    }

    public HBaseStorage(String columnList) throws ParseException, IOException {
        this(columnList, "");
    }

    public HBaseStorage(String columnList, String optString) throws ParseException, IOException {
        HBaseStorage.populateValidOptions();
        String[] colNames = columnList.split(" ");
        String[] optsArr = optString.split(" ");
        try {
            this.configuredOptions_ = parser_.parse(validOptions_, optsArr);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("[-loadKey] [-gt] [-gte] [-lt] [-lte] [-caching] [-caster]", validOptions_);
            throw e;
        }
        this.loadRowKey_ = this.configuredOptions_.hasOption("loadKey");
        for (String colName : colNames) {
            this.columnList_.add(Bytes.toByteArrays((String[])colName.split(":")));
        }
        this.m_conf = HBaseConfiguration.create();
        String defaultCaster = this.m_conf.get(CASTER_PROPERTY, STRING_CASTER);
        String casterOption = this.configuredOptions_.getOptionValue("caster", defaultCaster);
        if (STRING_CASTER.equalsIgnoreCase(casterOption)) {
            this.caster_ = new Utf8StorageConverter();
        } else if (BYTE_CASTER.equalsIgnoreCase(casterOption)) {
            this.caster_ = new HBaseBinaryConverter();
        } else {
            try {
                Class<?> casterClass = Class.forName(casterOption);
                this.caster_ = (LoadCaster)casterClass.newInstance();
            }
            catch (ClassCastException e) {
                LOG.error((Object)"Congifured caster does not implement LoadCaster interface.");
                throw new IOException(e);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"Configured caster class not found.", (Throwable)e);
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                LOG.error((Object)("Unable to instantiate configured caster " + casterOption), (Throwable)e);
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)("Illegal Access Exception for configured caster " + casterOption), (Throwable)e);
                throw new IOException(e);
            }
        }
        this.caching_ = Integer.valueOf(this.configuredOptions_.getOptionValue("caching", "100"));
        this.limit_ = Long.valueOf(this.configuredOptions_.getOptionValue("limit", "-1"));
        this.initScan();
    }

    private void initScan() {
        this.scan = new Scan();
        if (this.configuredOptions_.hasOption("gt")) {
            this.gt_ = Bytes.toBytesBinary((String)Utils.slashisize(this.configuredOptions_.getOptionValue("gt")));
            this.addFilter(CompareFilter.CompareOp.GREATER, this.gt_);
        }
        if (this.configuredOptions_.hasOption("lt")) {
            this.lt_ = Bytes.toBytesBinary((String)Utils.slashisize(this.configuredOptions_.getOptionValue("lt")));
            this.addFilter(CompareFilter.CompareOp.LESS, this.lt_);
        }
        if (this.configuredOptions_.hasOption("gte")) {
            this.gte_ = Bytes.toBytesBinary((String)Utils.slashisize(this.configuredOptions_.getOptionValue("gte")));
            this.addFilter(CompareFilter.CompareOp.GREATER_OR_EQUAL, this.gte_);
        }
        if (this.configuredOptions_.hasOption("lte")) {
            this.lte_ = Bytes.toBytesBinary((String)Utils.slashisize(this.configuredOptions_.getOptionValue("lte")));
            this.addFilter(CompareFilter.CompareOp.LESS_OR_EQUAL, this.lte_);
        }
    }

    private void addFilter(CompareFilter.CompareOp op, byte[] val) {
        LOG.info((Object)("Adding filter " + op.toString() + " with value " + Bytes.toStringBinary((byte[])val)));
        FilterList scanFilter = (FilterList)this.scan.getFilter();
        if (scanFilter == null) {
            scanFilter = new FilterList();
        }
        scanFilter.addFilter((Filter)new RowFilter(op, (WritableByteArrayComparable)new BinaryComparator(val)));
        this.scan.setFilter((Filter)scanFilter);
    }

    @Override
    public Tuple getNext() throws IOException {
        try {
            if (!this.initialized) {
                Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass(), new String[]{this.contextSignature});
                String projectedFields = p.getProperty(this.contextSignature + "_projectedFields");
                if (projectedFields != null) {
                    this.requiredFieldList = (LoadPushDown.RequiredFieldList)ObjectSerializer.deserialize(projectedFields);
                    this.pushProjection(this.requiredFieldList);
                }
                this.initialized = true;
            }
            if (this.reader.nextKeyValue()) {
                ImmutableBytesWritable rowKey = (ImmutableBytesWritable)this.reader.getCurrentKey();
                Result result = (Result)this.reader.getCurrentValue();
                int tupleSize = this.columnList_.size();
                if (this.loadRowKey_) {
                    ++tupleSize;
                }
                Tuple tuple = TupleFactory.getInstance().newTuple(tupleSize);
                int startIndex = 0;
                if (this.loadRowKey_) {
                    tuple.set(0, new DataByteArray(rowKey.get()));
                    ++startIndex;
                }
                for (int i = 0; i < this.columnList_.size(); ++i) {
                    byte[] cell = result.getValue(this.columnList_.get(i)[0], this.columnList_.get(i)[1]);
                    if (cell != null) {
                        tuple.set(i + startIndex, new DataByteArray(cell));
                        continue;
                    }
                    tuple.set(i + startIndex, null);
                }
                return tuple;
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return null;
    }

    @Override
    public InputFormat getInputFormat() {
        HBaseTableInputFormat inputFormat = new HBaseTableInputFormat.HBaseTableIFBuilder().withLimit(this.limit_).withGt(this.gt_).withGte(this.gte_).withLt(this.lt_).withLte(this.lte_).withConf(this.m_conf).build();
        return inputFormat;
    }

    @Override
    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.reader = reader;
    }

    @Override
    public void setUDFContextSignature(String signature) {
        this.contextSignature = signature;
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        job.getConfiguration().setBoolean("pig.noSplitCombination", true);
        this.m_conf = job.getConfiguration();
        HBaseConfiguration.addHbaseResources((Configuration)this.m_conf);
        TableMapReduceUtil.addDependencyJars((Configuration)job.getConfiguration(), (Class[])new Class[]{HTable.class, Lists.class, ZooKeeper.class});
        String tablename = location;
        if (location.startsWith("hbase://")) {
            tablename = location.substring(8);
        }
        if (this.m_table == null) {
            this.m_table = new HTable(this.m_conf, tablename);
        }
        this.m_table.setScannerCaching(this.caching_);
        this.m_conf.set("hbase.mapreduce.inputtable", tablename);
        if (this.m_conf.get("hbase.mapreduce.scan") != null) {
            return;
        }
        for (byte[][] col : this.columnList_) {
            this.scan.addColumn(col[0], col[1]);
        }
        if (this.requiredFieldList != null) {
            Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass(), new String[]{this.contextSignature});
            p.setProperty(this.contextSignature + "_projectedFields", ObjectSerializer.serialize(this.requiredFieldList));
        }
        this.m_conf.set("hbase.mapreduce.scan", HBaseStorage.convertScanToString(this.scan));
    }

    @Override
    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        return location;
    }

    private static String convertScanToString(Scan scan) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            scan.write((DataOutput)dos);
            return Base64.encodeBytes((byte[])out.toByteArray());
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return "";
        }
    }

    @Override
    public LoadCaster getLoadCaster() throws IOException {
        return this.caster_;
    }

    @Override
    public OutputFormat getOutputFormat() throws IOException {
        TableOutputFormat outputFormat = new TableOutputFormat();
        HBaseConfiguration.addHbaseResources((Configuration)this.m_conf);
        outputFormat.setConf(this.m_conf);
        return outputFormat;
    }

    @Override
    public void checkSchema(ResourceSchema s) throws IOException {
        if (!(this.caster_ instanceof LoadStoreCaster)) {
            LOG.error((Object)"Caster must implement LoadStoreCaster for writing to HBase.");
            throw new IOException("Bad Caster " + this.caster_.getClass());
        }
        this.schema_ = s;
    }

    @Override
    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
    }

    @Override
    public void putNext(Tuple t) throws IOException {
        if (!this.initialized) {
            Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass(), new String[]{this.contextSignature});
            String serializedSchema = p.getProperty(this.contextSignature + "_schema");
            if (serializedSchema != null) {
                this.schema_ = (ResourceSchema)ObjectSerializer.deserialize(serializedSchema);
            }
            this.initialized = true;
        }
        ResourceSchema.ResourceFieldSchema[] fieldSchemas = this.schema_ == null ? null : this.schema_.getFields();
        Put put = new Put(this.objToBytes(t.get(0), fieldSchemas == null ? DataType.findType(t.get(0)) : fieldSchemas[0].getType()));
        long ts = System.currentTimeMillis();
        for (int i = 1; i < t.size(); ++i) {
            put.add(this.columnList_.get(i - 1)[0], this.columnList_.get(i - 1)[1], ts, this.objToBytes(t.get(i), fieldSchemas == null ? DataType.findType(t.get(i)) : fieldSchemas[i].getType()));
        }
        try {
            this.writer.write(null, (Object)put);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private byte[] objToBytes(Object o, byte type) throws IOException {
        LoadStoreCaster caster = (LoadStoreCaster)this.caster_;
        if (o == null) {
            return null;
        }
        switch (type) {
            case 50: {
                return ((DataByteArray)o).get();
            }
            case 120: {
                return caster.toBytes((DataBag)o);
            }
            case 55: {
                return caster.toBytes((String)o);
            }
            case 25: {
                return caster.toBytes((Double)o);
            }
            case 20: {
                return caster.toBytes((Float)o);
            }
            case 10: {
                return caster.toBytes((Integer)o);
            }
            case 15: {
                return caster.toBytes((Long)o);
            }
            case 100: {
                return caster.toBytes((Map)o);
            }
            case 1: {
                return null;
            }
            case 110: {
                return caster.toBytes((Tuple)o);
            }
            case -1: {
                throw new IOException("Unable to determine type of " + o.getClass());
            }
        }
        throw new IOException("Unable to find a converter for tuple field " + o);
    }

    @Override
    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return location;
    }

    @Override
    public void setStoreFuncUDFContextSignature(String signature) {
        this.contextSignature = signature;
    }

    @Override
    public void setStoreLocation(String location, Job job) throws IOException {
        if (location.startsWith("hbase://")) {
            job.getConfiguration().set("hbase.mapred.outputtable", location.substring(8));
        } else {
            job.getConfiguration().set("hbase.mapred.outputtable", location);
        }
        Properties props = UDFContext.getUDFContext().getUDFProperties(this.getClass(), new String[]{this.contextSignature});
        if (!props.containsKey(this.contextSignature + "_schema")) {
            props.setProperty(this.contextSignature + "_schema", ObjectSerializer.serialize(this.schema_));
        }
        this.m_conf = HBaseConfiguration.addHbaseResources((Configuration)job.getConfiguration());
    }

    @Override
    public void cleanupOnFailure(String location, Job job) throws IOException {
    }

    @Override
    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    @Override
    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        int colOffset;
        int projOffset = colOffset = this.loadRowKey_ ? 1 : 0;
        this.requiredFieldList = requiredFieldList;
        List<LoadPushDown.RequiredField> requiredFields = requiredFieldList.getFields();
        if (requiredFieldList != null && requiredFields.size() > this.columnList_.size() + colOffset) {
            throw new FrontendException("The list of columns to project from HBase is larger than HBaseStorage is configured to load.");
        }
        ArrayList newColumns = Lists.newArrayListWithExpectedSize((int)requiredFields.size());
        if (this.loadRowKey_ && (requiredFields.size() < 1 || requiredFields.get(0).getIndex() != 0)) {
            this.loadRowKey_ = false;
            projOffset = 0;
        }
        for (int i = projOffset; i < requiredFields.size(); ++i) {
            int fieldIndex = requiredFields.get(i).getIndex();
            newColumns.add(this.columnList_.get(fieldIndex - colOffset));
        }
        this.columnList_ = newColumns;
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public WritableComparable<InputSplit> getSplitComparable(InputSplit split) throws IOException {
        return new WritableComparable<InputSplit>(){
            TableSplit tsplit = new TableSplit();

            public void readFields(DataInput in) throws IOException {
                this.tsplit.readFields(in);
            }

            public void write(DataOutput out) throws IOException {
                this.tsplit.write(out);
            }

            public int compareTo(InputSplit split) {
                return this.tsplit.compareTo((TableSplit)split);
            }
        };
    }
}

