/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COR
extends EvalFunc<DataBag>
implements Algebraic {
    protected Vector<String> schemaName = new Vector();
    private boolean flag = false;

    public COR() {
    }

    public COR(String ... schemaName) {
        for (int i = 0; i < schemaName.length; ++i) {
            this.schemaName.add(schemaName[i]);
            this.flag = true;
        }
    }

    @Override
    public DataBag exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        DataBag output = DefaultBagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < input.size(); ++i) {
            for (int j = i + 1; j < input.size(); ++j) {
                Tuple temp = TupleFactory.getInstance().newTuple(3);
                try {
                    if (this.flag) {
                        temp.set(0, this.schemaName.elementAt(i));
                        temp.set(1, this.schemaName.elementAt(j));
                    } else {
                        temp.set(0, "var" + i);
                        temp.set(1, "var" + j);
                    }
                    Tuple tempResult = COR.computeAll((DataBag)input.get(i), (DataBag)input.get(j));
                    double size = ((DataBag)input.get(i)).size();
                    double sum_x_y = (Double)tempResult.get(0);
                    double sum_x = (Double)tempResult.get(1);
                    double sum_y = (Double)tempResult.get(2);
                    double sum_x_square = (Double)tempResult.get(3);
                    double sum_y_square = (Double)tempResult.get(4);
                    double result = (size * sum_x_y - sum_x * sum_y) / Math.sqrt((size * sum_x_square - sum_x * sum_x) * (size * sum_y_square - sum_y * sum_y));
                    temp.set(2, result);
                }
                catch (Exception e) {
                    System.err.println("Failed to process input record; error - " + e.getMessage());
                    return null;
                }
                output.add(temp);
            }
        }
        return output;
    }

    public String toString() {
        if (this.flag) {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            if (this.schemaName != null) {
                for (String sch : this.schemaName) {
                    sb.append('\'' + sch + '\'' + ",");
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append(')');
            return sb.toString();
        }
        return "";
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermed.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName() + this.toString();
    }

    protected static Tuple combine(DataBag values) throws IOException {
        Tuple output = TupleFactory.getInstance().newTuple();
        Tuple tuple = TupleFactory.getInstance().newTuple(values.size());
        int ct = 0;
        try {
            for (Tuple t : values) {
                tuple.set(ct, t);
                ++ct;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int size = ((Tuple)tuple.get(0)).size();
            for (int i = 0; i < size; i += 2) {
                double count = 0.0;
                double sum_x_y = 0.0;
                double sum_x = 0.0;
                double sum_y = 0.0;
                double sum_x_square = 0.0;
                double sum_y_square = 0.0;
                for (int j = 0; j < tuple.size(); ++j) {
                    Tuple temp = (Tuple)tuple.get(j);
                    Tuple tem = (Tuple)temp.get(i);
                    count += ((Double)temp.get(i + 1)).doubleValue();
                    sum_x_y += ((Double)tem.get(0)).doubleValue();
                    sum_x += ((Double)tem.get(1)).doubleValue();
                    sum_y += ((Double)tem.get(2)).doubleValue();
                    sum_x_square += ((Double)tem.get(3)).doubleValue();
                    sum_y_square += ((Double)tem.get(4)).doubleValue();
                }
                Tuple result = TupleFactory.getInstance().newTuple(5);
                result.set(0, sum_x_y);
                result.set(1, sum_x);
                result.set(2, sum_y);
                result.set(3, sum_x_square);
                result.set(4, sum_y_square);
                output.append(result);
                output.append(count);
            }
        }
        catch (Exception e) {
            throw new IOException("Caught exception in COR.combine", e);
        }
        return output;
    }

    protected static Tuple computeAll(DataBag first, DataBag second) throws IOException {
        double sum_x_y = 0.0;
        double sum_x = 0.0;
        double sum_y = 0.0;
        double sum_x_square = 0.0;
        double sum_y_square = 0.0;
        Iterator<Tuple> iterator_x = first.iterator();
        Iterator<Tuple> iterator_y = second.iterator();
        try {
            while (iterator_x.hasNext()) {
                double x = (Double)iterator_x.next().get(0);
                double y = (Double)iterator_y.next().get(0);
                sum_x_y += x * y;
                sum_x += x;
                sum_y += y;
                sum_x_square += x * x;
                sum_y_square += y * y;
            }
        }
        catch (Exception e) {
            throw new IOException("Caught exception processing input", e);
        }
        Tuple result = TupleFactory.getInstance().newTuple(5);
        try {
            result.set(0, sum_x_y);
            result.set(1, sum_x);
            result.set(2, sum_y);
            result.set(3, sum_x_square);
            result.set(4, sum_y_square);
        }
        catch (Exception e) {
            throw new IOException("Caught exception processing result", e);
        }
        return result;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(this.getSchemaName(this.getClass().getName().toLowerCase(), input), 120));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Final
    extends EvalFunc<DataBag> {
        protected Vector<String> schemaName = new Vector();
        boolean flag = false;

        public Final() {
        }

        public Final(String ... schemaName) {
            for (int i = 0; i < schemaName.length; ++i) {
                this.schemaName.add(schemaName[i]);
                this.flag = true;
            }
        }

        @Override
        public DataBag exec(Tuple input) throws IOException {
            Tuple combined;
            if (input == null || input.size() == 0) {
                return null;
            }
            try {
                combined = COR.combine((DataBag)input.get(0));
            }
            catch (Exception e) {
                throw new IOException("Caught exception in COR.Final", e);
            }
            int count = 0;
            int totalSchemas = 2;
            while (totalSchemas * (totalSchemas - 1) < combined.size()) {
                ++totalSchemas;
            }
            DataBag output = DefaultBagFactory.getInstance().newDefaultBag();
            for (int i = 0; i < totalSchemas; ++i) {
                for (int j = i + 1; j < totalSchemas; ++j) {
                    Tuple result = TupleFactory.getInstance().newTuple(3);
                    try {
                        if (this.flag) {
                            result.set(0, this.schemaName.elementAt(i));
                            result.set(1, this.schemaName.elementAt(j));
                        } else {
                            result.set(0, "var" + i);
                            result.set(1, "var" + j);
                        }
                        Tuple tup = (Tuple)combined.get(count);
                        double tempCount = (Double)combined.get(count + 1);
                        double sum_x_y = (Double)tup.get(0);
                        double sum_x = (Double)tup.get(1);
                        double sum_y = (Double)tup.get(2);
                        double sum_x_square = (Double)tup.get(3);
                        double sum_y_square = (Double)tup.get(4);
                        double correl = (tempCount * sum_x_y - sum_x * sum_y) / Math.sqrt((tempCount * sum_x_square - sum_x * sum_x) * (tempCount * sum_y_square - sum_y * sum_y));
                        result.set(2, correl);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to process input record; error - " + e.getMessage());
                        return null;
                    }
                    output.add(result);
                    count += 2;
                }
            }
            return output;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Intermed
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple input) throws IOException {
            if (input == null || input.size() == 0) {
                return null;
            }
            try {
                return COR.combine((DataBag)input.get(0));
            }
            catch (Exception e) {
                throw new IOException("Caught exception in COR.Intermed", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Initial
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple input) throws IOException {
            if (input == null || input.size() == 0) {
                return null;
            }
            Tuple output = TupleFactory.getInstance().newTuple(input.size() * 2);
            try {
                int k = -1;
                for (int i = 0; i < input.size(); ++i) {
                    for (int j = i + 1; j < input.size(); ++j) {
                        DataBag first = (DataBag)input.get(i);
                        DataBag second = (DataBag)input.get(j);
                        output.set(k++, COR.computeAll(first, second));
                        output.set(k++, first.size());
                    }
                }
            }
            catch (Exception t) {
                System.err.println("Failed to process input record; error - " + t.getMessage());
                return null;
            }
            return output;
        }
    }
}

