/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.pig.FuncSpec;
import org.apache.pig.LoadFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigOutputFormat;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.io.ReadToEndLoader;
import org.apache.pig.impl.plan.OperatorKey;

public class PigFile {
    private String file = null;
    boolean append = false;

    public PigFile(String filename, boolean append) {
        this.file = filename;
        this.append = append;
    }

    public PigFile(String filename) {
        this.file = filename;
    }

    public DataBag load(LoadFunc lfunc, PigContext pigContext) throws IOException {
        DataBag content = BagFactory.getInstance().newDefaultBag();
        ReadToEndLoader loader = new ReadToEndLoader(lfunc, ConfigurationUtil.toConfiguration(pigContext.getProperties()), this.file, 0);
        Tuple f = null;
        while ((f = loader.getNext()) != null) {
            content.add(f);
        }
        return content;
    }

    public void store(DataBag data, FuncSpec storeFuncSpec, PigContext pigContext) throws IOException {
        OutputCommitter oc;
        Configuration conf = ConfigurationUtil.toConfiguration(pigContext.getProperties());
        JobContext jc = new JobContext(conf, new JobID());
        StoreFuncInterface sfunc = (StoreFuncInterface)PigContext.instantiateFuncFromSpec(storeFuncSpec);
        OutputFormat of = sfunc.getOutputFormat();
        POStore store = new POStore(new OperatorKey());
        store.setSFile(new FileSpec(this.file, storeFuncSpec));
        PigOutputFormat.setLocation(jc, store);
        TaskAttemptContext tac = new TaskAttemptContext(conf, new TaskAttemptID());
        PigOutputFormat.setLocation((JobContext)tac, store);
        try {
            of.checkOutputSpecs(jc);
            oc = of.getOutputCommitter(tac);
            oc.setupJob(jc);
            oc.setupTask(tac);
            RecordWriter rw = of.getRecordWriter(tac);
            sfunc.prepareToWrite(rw);
            for (Tuple row : data) {
                sfunc.putNext(row);
            }
            rw.close(tac);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (oc.needsTaskCommit(tac)) {
            oc.commitTask(tac);
        }
        oc.cleanupJob(jc);
    }

    public String toString() {
        return "PigFile: file: " + this.file + ", append: " + this.append;
    }
}

