/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopLevelProjectFinder
extends LOVisitor {
    List<LOProject> mProjectList = new ArrayList<LOProject>();

    public TopLevelProjectFinder(LogicalPlan plan) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DepthFirstWalker<LogicalOperator, LogicalPlan>(plan));
    }

    @Override
    protected void visit(LODistinct dt) throws VisitorException {
    }

    @Override
    protected void visit(LOFilter filter) throws VisitorException {
    }

    @Override
    protected void visit(LOForEach forEach) throws VisitorException {
    }

    @Override
    protected void visit(LOSort s) throws VisitorException {
    }

    @Override
    protected void visit(LOProject project) throws VisitorException {
        List<LOProject> projectPreds = ((LogicalPlan)this.getPlan()).getPredecessors(project);
        if (projectPreds == null) {
            this.mProjectList.add(project);
        }
    }

    public List<LOProject> getProjectList() {
        return this.mProjectList;
    }

    public Set<LOProject> getProjectSet() {
        return new HashSet<LOProject>(this.mProjectList);
    }

    public Set<LOProject> getProjectStarSet() {
        HashSet<LOProject> projectStarSet = new HashSet<LOProject>();
        for (LOProject project : this.getProjectSet()) {
            if (!project.isStar() || ((LogicalPlan)this.getPlan()).getPredecessors(project) != null) continue;
            projectStarSet.add(project);
        }
        return projectStarSet.size() == 0 ? null : projectStarSet;
    }
}

